/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.artifactory;

import com.playtika.test.common.properties.CommonContainerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.artifactory")
public class ArtifactoryProperties
extends CommonContainerProperties {
    static final String ARTIFACTORY_BEAN_NAME = "artifactory";
    boolean enabled = true;
    String networkAlias = "artifactory";
    String username = "admin";
    String password = "password";
    int restApiPort = 8081;
    int generalPort = 8082;

    public ArtifactoryProperties() {
        this.setWaitTimeoutInSeconds(120L);
    }

    public String getDefaultDockerImage() {
        return "releases-docker.jfrog.io/jfrog/artifactory-oss:7.25.6";
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public String getNetworkAlias() {
        return this.networkAlias;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public int getRestApiPort() {
        return this.restApiPort;
    }

    public int getGeneralPort() {
        return this.generalPort;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setNetworkAlias(String networkAlias) {
        this.networkAlias = networkAlias;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public void setPassword(String password) {
        this.password = password;
    }

    public void setRestApiPort(int restApiPort) {
        this.restApiPort = restApiPort;
    }

    public void setGeneralPort(int generalPort) {
        this.generalPort = generalPort;
    }

    public String toString() {
        return "ArtifactoryProperties(enabled=" + this.isEnabled() + ", networkAlias=" + this.getNetworkAlias() + ", username=" + this.getUsername() + ", password=" + this.getPassword() + ", restApiPort=" + this.getRestApiPort() + ", generalPort=" + this.getGeneralPort() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ArtifactoryProperties)) {
            return false;
        }
        ArtifactoryProperties other = (ArtifactoryProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getRestApiPort() != other.getRestApiPort()) {
            return false;
        }
        if (this.getGeneralPort() != other.getGeneralPort()) {
            return false;
        }
        String this$networkAlias = this.getNetworkAlias();
        String other$networkAlias = other.getNetworkAlias();
        if (this$networkAlias == null ? other$networkAlias != null : !this$networkAlias.equals(other$networkAlias)) {
            return false;
        }
        String this$username = this.getUsername();
        String other$username = other.getUsername();
        if (this$username == null ? other$username != null : !this$username.equals(other$username)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        return !(this$password == null ? other$password != null : !this$password.equals(other$password));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ArtifactoryProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getRestApiPort();
        result = result * 59 + this.getGeneralPort();
        String $networkAlias = this.getNetworkAlias();
        result = result * 59 + ($networkAlias == null ? 43 : $networkAlias.hashCode());
        String $username = this.getUsername();
        result = result * 59 + ($username == null ? 43 : $username.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        return result;
    }
}

