/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.artifactory;

import com.playtika.test.artifactory.ArtifactoryProperties;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.artifactory.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ArtifactoryProperties.class})
public class EmbeddedArtifactoryBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedArtifactoryBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean(name={"artifactoryWaitStrategy"})
    public WaitStrategy artifactoryWaitStrategy(ArtifactoryProperties properties) {
        return new HttpWaitStrategy().forPath("/").forPort(properties.getGeneralPort()).forStatusCode(200);
    }

    @Bean(name={"artifactory"}, destroyMethod="stop")
    public GenericContainer<?> artifactory(ConfigurableEnvironment environment, ArtifactoryProperties properties, WaitStrategy artifactoryWaitStrategy) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getRestApiPort(), properties.getGeneralPort()}).withNetwork(Network.SHARED).withNetworkAliases(new String[]{properties.getNetworkAlias()}).waitingFor(artifactoryWaitStrategy);
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(container, environment, properties);
        return container;
    }

    private void registerEnvironment(GenericContainer<?> artifactory, ConfigurableEnvironment environment, ArtifactoryProperties properties) {
        Integer mappedPort = artifactory.getMappedPort(properties.generalPort);
        String host = artifactory.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.artifactory.host", host);
        map.put("embedded.artifactory.port", mappedPort);
        map.put("embedded.artifactory.username", properties.getUsername());
        map.put("embedded.artifactory.password", properties.getPassword());
        log.info("Started Artifactory server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedArtifactoryInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

