/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.artifactory;

import com.playtika.testcontainer.artifactory.ArtifactoryProperties;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.artifactory.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ArtifactoryProperties.class})
public class EmbeddedArtifactoryBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedArtifactoryBootstrapConfiguration.class);
    private static final String ARTIFACTORY_NETWORK_ALIAS = "artifactory.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean(name={"artifactoryWaitStrategy"})
    public WaitStrategy artifactoryWaitStrategy(ArtifactoryProperties properties) {
        return new HttpWaitStrategy().forPath("/").forPort(properties.getGeneralPort()).forStatusCode(200);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="artifactory")
    ToxiproxyContainer.ContainerProxy artifactoryContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="artifactory") GenericContainer<?> artifactory, ArtifactoryProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(artifactory, properties.getRestApiPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.artifactory.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.artifactory.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.artifactory.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedArtifactoryToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Artifactory ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"artifactory"}, destroyMethod="stop")
    public GenericContainer<?> artifactory(ConfigurableEnvironment environment, ArtifactoryProperties properties, WaitStrategy artifactoryWaitStrategy, Optional<Network> network) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getRestApiPort(), properties.getGeneralPort()}).withNetwork(Network.SHARED).withNetworkAliases(new String[]{properties.getNetworkAlias(), ARTIFACTORY_NETWORK_ALIAS}).waitingFor(artifactoryWaitStrategy);
        network.ifPresent(arg_0 -> ((GenericContainer)container).withNetwork(arg_0));
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(container, environment, properties);
        return container;
    }

    private void registerEnvironment(GenericContainer<?> artifactory, ConfigurableEnvironment environment, ArtifactoryProperties properties) {
        Integer mappedPort = artifactory.getMappedPort(properties.generalPort);
        String host = artifactory.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.artifactory.host", host);
        map.put("embedded.artifactory.port", mappedPort);
        map.put("embedded.artifactory.username", properties.getUsername());
        map.put("embedded.artifactory.password", properties.getPassword());
        map.put("embedded.artifactory.staticNetworkAlias", ARTIFACTORY_NETWORK_ALIAS);
        map.put("embedded.artifactory.internalRestApiPort", properties.getRestApiPort());
        map.put("embedded.artifactory.internalGeneralPort", properties.getGeneralPort());
        log.info("Started Artifactory server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedArtifactoryInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

