/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.azurite;

import com.playtika.testcontainer.azurite.AzuriteProperties;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.azurite.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={AzuriteProperties.class})
public class EmbeddedAzuriteBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedAzuriteBootstrapConfiguration.class);
    private static final String AZURITE_BLOB_NETWORK_ALIAS = "azurite-blob.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="azurite")
    ToxiproxyContainer.ContainerProxy azuriteBlobContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="azurite") GenericContainer<?> azurite, AzuriteProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(azurite, properties.getBlobStoragePort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.azurite.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.azurite.toxiproxy.blobStoragePort", proxy.getProxyPort());
        map.put("embedded.azurite.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedAzuriteBlobToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Azurite ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="azurite")
    ToxiproxyContainer.ContainerProxy azuriteQueueContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="azurite") GenericContainer<?> azurite, AzuriteProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(azurite, properties.getQueueStoragePort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.azurite.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.azurite.toxiproxy.queueStoragePor", proxy.getProxyPort());
        map.put("embedded.azurite.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedAzuriteQueueToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Azurite ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="azurite")
    ToxiproxyContainer.ContainerProxy azuriteTableContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="azurite") GenericContainer<?> azurite, AzuriteProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(azurite, properties.getTableStoragePort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.azurite.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.azurite.toxiproxy.tableStoragePort", proxy.getProxyPort());
        map.put("embedded.azurite.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedAzuriteTableToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Azurite ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"azurite"}, destroyMethod="stop")
    public GenericContainer<?> azurite(ConfigurableEnvironment environment, AzuriteProperties properties, Optional<Network> network) {
        GenericContainer azuriteContainer = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getBlobStoragePort(), properties.getQueueStoragePort(), properties.getTableStoragePort()}).withNetworkAliases(new String[]{AZURITE_BLOB_NETWORK_ALIAS}).withCommand(new String[]{"azurite", "-l", "/data", "--blobHost", "0.0.0.0", "--blobPort", String.valueOf(properties.getBlobStoragePort()), "--queueHost", "0.0.0.0", "--queuePort", String.valueOf(properties.getQueueStoragePort()), "--tableHost", "0.0.0.0", "--tablePort", String.valueOf(properties.getTableStoragePort()), "--skipApiVersionCheck"});
        network.ifPresent(arg_0 -> ((GenericContainer)azuriteContainer).withNetwork(arg_0));
        ContainerUtils.configureCommonsAndStart((GenericContainer)azuriteContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(azuriteContainer, environment, properties);
        return azuriteContainer;
    }

    private void registerEnvironment(GenericContainer<?> azurite, ConfigurableEnvironment environment, AzuriteProperties properties) {
        Integer mappedBlobStoragePort = azurite.getMappedPort(properties.getBlobStoragePort());
        Integer mappedQueueStoragePort = azurite.getMappedPort(properties.getQueueStoragePort());
        Integer mappedTableStoragePort = azurite.getMappedPort(properties.getTableStoragePort());
        String host = azurite.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.azurite.host", host);
        map.put("embedded.azurite.blobStoragePort", mappedBlobStoragePort);
        map.put("embedded.azurite.queueStoragePor", mappedQueueStoragePort);
        map.put("embedded.azurite.tableStoragePort", mappedTableStoragePort);
        map.put("embedded.azurite.account-name", "devstoreaccount1");
        map.put("embedded.azurite.account-key", "Eby8vdM02xNOcqFlqUwJPLlmEtlCDXJ1OUzFT50uSRZ6IFsuFq2UVErCz4I6tq/K1SZFPTOtr/KBHBeksoGMGw==");
        map.put("embedded.azurite.blob-endpoint", "http://" + host + ":" + mappedBlobStoragePort + "/devstoreaccount1");
        map.put("embedded.azurite.queue-endpoint", "http://" + host + ":" + mappedQueueStoragePort + "/devstoreaccount1");
        map.put("embedded.azurite.table-endpoint", "http://" + host + ":" + mappedTableStoragePort + "/devstoreaccount1");
        map.put("embedded.azurite.networkAlias", AZURITE_BLOB_NETWORK_ALIAS);
        log.info("Started Azurite. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedAzuriteInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

