/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.cassandra;

import com.playtika.test.cassandra.CassandraProperties;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.common.utils.FileUtils;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.script.ScriptException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.CassandraContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.delegate.CassandraDatabaseDelegate;
import org.testcontainers.delegate.DatabaseDelegate;
import org.testcontainers.ext.ScriptUtils;

@Configuration
@AutoConfigureOrder
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(name={"embedded.cassandra.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={CassandraProperties.class})
public class EmbeddedCassandraBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCassandraBootstrapConfiguration.class);
    private final ResourceLoader resourceLoader;

    @Bean(name={"embeddedCassandra"}, destroyMethod="stop")
    public CassandraContainer cassandra(ConfigurableEnvironment environment, CassandraProperties properties) throws Exception {
        CassandraContainer cassandra = (CassandraContainer)new CassandraContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()});
        cassandra = (CassandraContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)cassandra, (CommonContainerProperties)properties, (Logger)log);
        this.initKeyspace(properties, cassandra);
        Map<String, Object> cassandraEnv = EmbeddedCassandraBootstrapConfiguration.registerCassandraEnvironment(environment, cassandra, properties);
        log.info("Started Cassandra. Connection details: {}", cassandraEnv);
        return cassandra;
    }

    static Map<String, Object> registerCassandraEnvironment(ConfigurableEnvironment environment, CassandraContainer cassandra, CassandraProperties properties) {
        String host = cassandra.getHost();
        Integer mappedPort = cassandra.getMappedPort(properties.getPort());
        LinkedHashMap<String, Object> cassandraEnv = new LinkedHashMap<String, Object>();
        cassandraEnv.put("embedded.cassandra.port", mappedPort);
        cassandraEnv.put("embedded.cassandra.host", host);
        cassandraEnv.put("embedded.cassandra.datacenter", "datacenter1");
        cassandraEnv.put("embedded.cassandra.keyspace-name", properties.keyspaceName);
        MapPropertySource propertySource = new MapPropertySource("embeddedCassandraInfo", cassandraEnv);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        return cassandraEnv;
    }

    private void initKeyspace(CassandraProperties properties, CassandraContainer<?> cassandra) throws ScriptException {
        String initScriptContent = this.prepareCassandraInitScript(properties);
        try (CassandraDatabaseDelegate databaseDelegate = new CassandraDatabaseDelegate(cassandra);){
            ScriptUtils.executeDatabaseScript((DatabaseDelegate)databaseDelegate, (String)"init.cql", (String)initScriptContent);
        }
    }

    private String prepareCassandraInitScript(CassandraProperties properties) {
        return FileUtils.resolveTemplateAsString((ResourceLoader)this.resourceLoader, (String)"cassandra-init.sql", content -> content.replace("{{keyspaceName}}", properties.keyspaceName)).replace("{{replicationFactor}}", Integer.toString(properties.replicationFactor));
    }

    public EmbeddedCassandraBootstrapConfiguration(ResourceLoader resourceLoader) {
        this.resourceLoader = resourceLoader;
    }
}

