/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.cassandra;

import com.datastax.oss.driver.api.core.CqlSession;
import com.playtika.testcontainer.common.spring.DependsOnPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(afterName={"org.springframework.boot.autoconfigure.cassandra.CassandraAutoConfiguration"})
@ConditionalOnClass(value={CqlSession.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(name={"embedded.cassandra.enabled"}, matchIfMissing=true)
public class EmbeddedCassandraDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCassandraDependenciesAutoConfiguration.class);

    @Configuration
    public static class CassandraSessionDependencyContextHelper {
        @Bean
        public static BeanFactoryPostProcessor cassandraSessionDependencyPostProcessor() {
            return new DependsOnPostProcessor(CqlSession.class, new String[]{"embeddedCassandra"});
        }
    }
}

