/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.clickhouse;

import com.playtika.test.clickhouse.ClickHouseProperties;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.ClickHouseContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.shaded.com.google.common.base.Strings;
import org.testcontainers.utility.DockerImageName;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.clickhouse.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ClickHouseProperties.class})
public class EmbeddedClickHouseBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedClickHouseBootstrapConfiguration.class);

    @Bean(name={"embeddedClickHouse"}, destroyMethod="stop")
    public ConcreteClickHouseContainer clickHouseContainer(ConfigurableEnvironment environment, ClickHouseProperties properties) {
        log.info("Starting ClickHouse server. Docker image: {}", (Object)properties.getDockerImage());
        DockerImageName dockerImageName = DockerImageName.parse((String)properties.dockerImage);
        if (properties.asCompatibleImage) {
            dockerImageName = dockerImageName.asCompatibleSubstituteFor("yandex/clickhouse-server");
        }
        ConcreteClickHouseContainer clickHouseContainer = new ConcreteClickHouseContainer(dockerImageName);
        String username = Strings.isNullOrEmpty((String)properties.getUser()) ? clickHouseContainer.getUsername() : properties.getUser();
        String password = Strings.isNullOrEmpty((String)properties.getPassword()) ? clickHouseContainer.getPassword() : properties.getPassword();
        clickHouseContainer.addEnv("CLICKHOUSE_USER", username);
        clickHouseContainer.addEnv("CLICKHOUSE_PASSWORD", Strings.nullToEmpty((String)password));
        clickHouseContainer = (ConcreteClickHouseContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)clickHouseContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerClickHouseEnvironment(clickHouseContainer, environment, properties, username, password);
        return clickHouseContainer;
    }

    private void registerClickHouseEnvironment(ConcreteClickHouseContainer clickHouseContainer, ConfigurableEnvironment environment, ClickHouseProperties properties, String username, String password) {
        Integer mappedPort = clickHouseContainer.getMappedPort(properties.port);
        String host = clickHouseContainer.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.clickhouse.schema", "default");
        map.put("embedded.clickhouse.host", host);
        map.put("embedded.clickhouse.port", mappedPort);
        map.put("embedded.clickhouse.user", username);
        map.put("embedded.clickhouse.password", password);
        log.info("Started ClickHouse server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedClickHouseInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private static class ConcreteClickHouseContainer
    extends ClickHouseContainer {
        public ConcreteClickHouseContainer(DockerImageName dockerImageName) {
            super(dockerImageName);
        }
    }
}

