/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.clickhouse;

import com.playtika.test.common.spring.DependsOnPostProcessor;
import javax.sql.DataSource;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder
@ConditionalOnClass(value={DataSource.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(name={"embedded.clickhouse.enabled"}, havingValue="true", matchIfMissing=true)
@AutoConfigureAfter(value={DataSourceAutoConfiguration.class})
public class EmbeddedClickHouseDependenciesAutoConfiguration {

    @Configuration
    public static class ClickHouseDependencyContextHelper {
        @Bean
        public static BeanFactoryPostProcessor clickHouseContainerDependencyPostProcessor() {
            return new DependsOnPostProcessor(DataSource.class, new String[]{"embeddedClickHouse"});
        }
    }
}

