/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.consul;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.consul.ConsulProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@EnableConfigurationProperties(value={ConsulProperties.class})
@ConditionalOnProperty(name={"embedded.consul.enabled"}, matchIfMissing=true)
public class EmbeddedConsulBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedConsulBootstrapConfiguration.class);

    @Bean(name={"embeddedConsul"}, destroyMethod="stop")
    public GenericContainer<?> consulContainer(ConfigurableEnvironment environment, ConsulProperties properties) {
        GenericContainer consul = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).waitingFor((WaitStrategy)Wait.forHttp((String)"/v1/status/leader").forStatusCode(200)).withStartupTimeout(properties.getTimeoutDuration());
        if (properties.getConfigurationFile() != null) {
            consul = consul.withClasspathResourceMapping(properties.getConfigurationFile(), "/consul/config/test.hcl", BindMode.READ_ONLY);
        }
        consul = ContainerUtils.configureCommonsAndStart((GenericContainer)consul, (CommonContainerProperties)properties, (Logger)log);
        this.registerConsulEnvironment(consul, environment, properties);
        return consul;
    }

    private void registerConsulEnvironment(GenericContainer<?> consul, ConfigurableEnvironment environment, ConsulProperties properties) {
        Integer mappedPort = consul.getMappedPort(properties.getPort());
        String host = consul.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.consul.port", mappedPort);
        map.put("embedded.consul.host", host);
        log.info("Started consul. Connection Details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedConsulInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

