/*
* The MIT License (MIT)
*
* Copyright (c) 2017 Playtika
*
* Permission is hereby granted, free of charge, to any person obtaining a copy
* of this software and associated documentation files (the "Software"), to deal
* in the Software without restriction, including without limitation the rights
* to use, copy, modify, merge, publish, distribute, sublicense, and/or sell
* copies of the Software, and to permit persons to whom the Software is
* furnished to do so, subject to the following conditions:
*
* The above copyright notice and this permission notice shall be included in all
* copies or substantial portions of the Software.
*
* THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
* IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
* FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT. IN NO EVENT SHALL THE
* AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
* LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING FROM,
* OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER DEALINGS IN THE
* SOFTWARE.
 */
package com.playtika.test.couchbase;

import lombok.Data;
import org.springframework.boot.context.properties.ConfigurationProperties;

@Data
@ConfigurationProperties("embedded.couchbase")
public class CouchbaseProperties {
    public static final String BEAN_NAME_EMBEDDED_COUCHBASE = "embeddedCouchbase";
    boolean enabled;
    String services = "kv,index,n1ql,fts";
    String dockerImage = "couchbase:community-4.5.1";
    int clusterRamMb = 256;
    int bucketRamMb = 100;
    String bucketType = "couchbase";

    final String user = "Administrator";
    final String password = "password";
    final String bucket = "test";

    final int httpDirectPort = 8091;
    final int queryServicePort = 8092;
    final int queryRestTrafficPort = 8093;
    final int searchServicePort = 8094;
    final int analyticsServicePort = 8095;

    final int memcachedSslPort = 11207;
    final int memcachedPort = 11211;
    final int carrierDirectPort = 11210;
    final int queryRestTrafficSslPort = 18091;
    final int queryServiceSslPort = 18092;
    final int n1qlSslPort = 18093;
    final int searchServiceHttpsPort = 18094;
}
