/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.couchbase.CouchbaseProperties;
import com.playtika.test.couchbase.rest.CreateBucket;
import com.playtika.test.couchbase.rest.CreateBucketUser;
import com.playtika.test.couchbase.rest.CreatePrimaryIndex;
import com.playtika.test.couchbase.rest.SetupAdminUserAndPassword;
import com.playtika.test.couchbase.rest.SetupIndexesType;
import com.playtika.test.couchbase.rest.SetupNodeStorage;
import com.playtika.test.couchbase.rest.SetupRamQuotas;
import com.playtika.test.couchbase.rest.SetupServices;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.WaitAllStrategy;
import org.testcontainers.containers.wait.WaitStrategy;

class CouchbaseContainerFactory {
    private static final Logger log = LoggerFactory.getLogger(CouchbaseContainerFactory.class);

    static GenericContainer create(CouchbaseProperties properties, Logger containerLogger) {
        return ((FixedHostPortGenericContainer)new FixedHostPortGenericContainer(properties.dockerImage).withFixedExposedPort(properties.carrierDirectPort, properties.carrierDirectPort).withFixedExposedPort(properties.httpDirectPort, properties.httpDirectPort).withFixedExposedPort(properties.queryServicePort, properties.queryServicePort).withFixedExposedPort(properties.queryRestTrafficPort, properties.queryRestTrafficPort).withFixedExposedPort(properties.searchServicePort, properties.searchServicePort).withFixedExposedPort(properties.analyticsServicePort, properties.analyticsServicePort).withFixedExposedPort(properties.memcachedSslPort, properties.memcachedSslPort).withFixedExposedPort(properties.memcachedPort, properties.memcachedPort).withFixedExposedPort(properties.queryRestTrafficSslPort, properties.queryRestTrafficSslPort).withFixedExposedPort(properties.queryServiceSslPort, properties.queryServiceSslPort).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)containerLogger))).waitingFor(CouchbaseContainerFactory.getCompositeWaitStrategy(properties));
    }

    private static WaitStrategy getCompositeWaitStrategy(CouchbaseProperties properties) {
        return new WaitAllStrategy().withStrategy((WaitStrategy)new SetupNodeStorage(properties)).withStrategy((WaitStrategy)new SetupRamQuotas(properties)).withStrategy((WaitStrategy)new SetupServices(properties)).withStrategy((WaitStrategy)new SetupIndexesType(properties)).withStrategy((WaitStrategy)new SetupAdminUserAndPassword(properties)).withStrategy((WaitStrategy)new CreateBucket(properties)).withStrategy((WaitStrategy)new CreatePrimaryIndex(properties)).withStrategy((WaitStrategy)new CreateBucketUser(properties)).withStartupTimeout(ContainerUtils.DEFAULT_CONTAINER_WAIT_DURATION);
    }
}

