/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.AptGetPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.couchbase.CouchbaseProperties;
import java.util.Collections;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnBean(value={CouchbaseProperties.class})
@ConditionalOnProperty(value={"embedded.couchbase.enabled"}, matchIfMissing=true)
public class EmbeddedCouchbaseTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.couchbase.install")
    public InstallPackageProperties couchbasePackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute2"));
        return properties;
    }

    @Bean
    public PackageInstaller couchbasePackageInstaller(InstallPackageProperties couchbasePackageProperties, GenericContainer couchbase) {
        return new AptGetPackageInstaller(couchbasePackageProperties, couchbase);
    }

    @Bean
    @ConditionalOnMissingBean(name={"couchbaseNetworkTestOperations"})
    public NetworkTestOperations couchbaseNetworkTestOperations(GenericContainer couchbase) {
        return new DefaultNetworkTestOperations(couchbase);
    }
}

