/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.playtika.test.couchbase.CouchbaseContainerFactory;
import com.playtika.test.couchbase.CouchbaseProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;

@Configuration
@AutoConfigureOrder(value=-2147483648)
@ConditionalOnProperty(name={"embedded.couchbase.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class EmbeddedCouchbaseAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCouchbaseAutoConfiguration.class);

    @Bean(name={"embeddedCouchbase"}, destroyMethod="stop")
    public GenericContainer couchbase(ConfigurableEnvironment environment, CouchbaseProperties properties) throws Exception {
        log.info("Starting couchbase server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer couchbase = CouchbaseContainerFactory.create(properties, log);
        couchbase.start();
        this.registerCouchbaseEnvironment(couchbase, environment, properties);
        return couchbase;
    }

    private void registerCouchbaseEnvironment(GenericContainer couchbase, ConfigurableEnvironment environment, CouchbaseProperties properties) {
        Integer mappedHttpPort = couchbase.getMappedPort(properties.httpDirectPort);
        Integer mappedCarrierPort = couchbase.getMappedPort(properties.carrierDirectPort);
        String host = couchbase.getContainerIpAddress();
        System.setProperty("com.couchbase.bootstrapHttpDirectPort", String.valueOf(mappedHttpPort));
        System.setProperty("com.couchbase.bootstrapCarrierDirectPort", String.valueOf(mappedCarrierPort));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.couchbase.bootstrapHttpDirectPort", mappedHttpPort);
        map.put("embedded.couchbase.bootstrapCarrierDirectPort", mappedCarrierPort);
        map.put("embedded.couchbase.host", host);
        map.put("embedded.couchbase.bucket", properties.bucket);
        map.put("embedded.couchbase.user", properties.bucket);
        map.put("embedded.couchbase.password", properties.password);
        log.info("Started couchbase server. Connection details {},  Admin UI: http://localhost:{}, user: {}, password: {}", new Object[]{map, mappedHttpPort, properties.getUser(), properties.getPassword()});
        MapPropertySource propertySource = new MapPropertySource("embeddedCouchbaseInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

