/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.couchbase.client.CouchbaseClient;
import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.playtika.test.common.spring.DependsOnPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@Configuration
@AutoConfigureOrder
@AutoConfigureAfter(name={"org.springframework.boot.autoconfigure.data.couchbase.CouchbaseDataAutoConfiguration"})
public class EmbeddedCouchbaseDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCouchbaseDependenciesAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={CouchbaseClient.class})
    public static class CouchbaseClientDependencyContext {
        @Bean
        public BeanFactoryPostProcessor couchbaseClientDependencyPostProcessor() {
            return new DependsOnPostProcessor(CouchbaseClient.class, new String[]{"embeddedCouchbase"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={AsyncBucket.class})
    public static class CouchbaseAsyncBucketDependencyContext {
        @Bean
        public BeanFactoryPostProcessor asyncBucketDependencyPostProcessor() {
            return new DependsOnPostProcessor(AsyncBucket.class, new String[]{"embeddedCouchbase"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={Bucket.class})
    public static class CouchbaseBucketDependencyContext {
        @Bean
        public BeanFactoryPostProcessor bucketDependencyPostProcessor() {
            return new DependsOnPostProcessor(Bucket.class, new String[]{"embeddedCouchbase"});
        }
    }
}

