/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.playtika.test.common.properties.CommonContainerProperties;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.couchbase")
public class CouchbaseProperties
extends CommonContainerProperties {
    public static final String BEAN_NAME_EMBEDDED_COUCHBASE = "embeddedCouchbase";
    String services = "kv,index,n1ql,fts";
    String dockerImage = "couchbase:community-4.5.1";
    int clusterRamMb = 256;
    int bucketRamMb = 100;
    String bucketType = "couchbase";
    String host = "localhost";
    String user = "Administrator";
    String password = "password";
    String bucket = "test";
    int bootstrapHttpDirectPort = 8091;
    int httpDirectPort = 8091;
    int queryServicePort = 8092;
    int queryRestTrafficPort = 8093;
    int searchServicePort = 8094;
    int analyticsServicePort = 8095;
    int memcachedSslPort = 11207;
    int memcachedPort = 11211;
    int bootstrapCarrierDirectPort = 11210;
    int carrierDirectPort = 11210;
    int queryRestTrafficSslPort = 18091;
    int queryServiceSslPort = 18092;
    int n1qlSslPort = 18093;
    int searchServiceHttpsPort = 18094;

    public void setPassword(String password) {
        if (password.length() < 6) {
            throw new IllegalArgumentException("Couchbase requires password length >= 6 chars, password=" + password);
        }
        this.password = password;
    }

    public String getCredentials() {
        return String.format("%s:%s", this.user, this.password);
    }

    public String getServices() {
        return this.services;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public int getClusterRamMb() {
        return this.clusterRamMb;
    }

    public int getBucketRamMb() {
        return this.bucketRamMb;
    }

    public String getBucketType() {
        return this.bucketType;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBucket() {
        return this.bucket;
    }

    public int getBootstrapHttpDirectPort() {
        return this.bootstrapHttpDirectPort;
    }

    public int getHttpDirectPort() {
        return this.httpDirectPort;
    }

    public int getQueryServicePort() {
        return this.queryServicePort;
    }

    public int getQueryRestTrafficPort() {
        return this.queryRestTrafficPort;
    }

    public int getSearchServicePort() {
        return this.searchServicePort;
    }

    public int getAnalyticsServicePort() {
        return this.analyticsServicePort;
    }

    public int getMemcachedSslPort() {
        return this.memcachedSslPort;
    }

    public int getMemcachedPort() {
        return this.memcachedPort;
    }

    public int getBootstrapCarrierDirectPort() {
        return this.bootstrapCarrierDirectPort;
    }

    public int getCarrierDirectPort() {
        return this.carrierDirectPort;
    }

    public int getQueryRestTrafficSslPort() {
        return this.queryRestTrafficSslPort;
    }

    public int getQueryServiceSslPort() {
        return this.queryServiceSslPort;
    }

    public int getN1qlSslPort() {
        return this.n1qlSslPort;
    }

    public int getSearchServiceHttpsPort() {
        return this.searchServiceHttpsPort;
    }

    public void setServices(String services) {
        this.services = services;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setClusterRamMb(int clusterRamMb) {
        this.clusterRamMb = clusterRamMb;
    }

    public void setBucketRamMb(int bucketRamMb) {
        this.bucketRamMb = bucketRamMb;
    }

    public void setBucketType(String bucketType) {
        this.bucketType = bucketType;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public void setBootstrapHttpDirectPort(int bootstrapHttpDirectPort) {
        this.bootstrapHttpDirectPort = bootstrapHttpDirectPort;
    }

    public void setHttpDirectPort(int httpDirectPort) {
        this.httpDirectPort = httpDirectPort;
    }

    public void setQueryServicePort(int queryServicePort) {
        this.queryServicePort = queryServicePort;
    }

    public void setQueryRestTrafficPort(int queryRestTrafficPort) {
        this.queryRestTrafficPort = queryRestTrafficPort;
    }

    public void setSearchServicePort(int searchServicePort) {
        this.searchServicePort = searchServicePort;
    }

    public void setAnalyticsServicePort(int analyticsServicePort) {
        this.analyticsServicePort = analyticsServicePort;
    }

    public void setMemcachedSslPort(int memcachedSslPort) {
        this.memcachedSslPort = memcachedSslPort;
    }

    public void setMemcachedPort(int memcachedPort) {
        this.memcachedPort = memcachedPort;
    }

    public void setBootstrapCarrierDirectPort(int bootstrapCarrierDirectPort) {
        this.bootstrapCarrierDirectPort = bootstrapCarrierDirectPort;
    }

    public void setCarrierDirectPort(int carrierDirectPort) {
        this.carrierDirectPort = carrierDirectPort;
    }

    public void setQueryRestTrafficSslPort(int queryRestTrafficSslPort) {
        this.queryRestTrafficSslPort = queryRestTrafficSslPort;
    }

    public void setQueryServiceSslPort(int queryServiceSslPort) {
        this.queryServiceSslPort = queryServiceSslPort;
    }

    public void setN1qlSslPort(int n1qlSslPort) {
        this.n1qlSslPort = n1qlSslPort;
    }

    public void setSearchServiceHttpsPort(int searchServiceHttpsPort) {
        this.searchServiceHttpsPort = searchServiceHttpsPort;
    }

    public String toString() {
        return "CouchbaseProperties(services=" + this.getServices() + ", dockerImage=" + this.getDockerImage() + ", clusterRamMb=" + this.getClusterRamMb() + ", bucketRamMb=" + this.getBucketRamMb() + ", bucketType=" + this.getBucketType() + ", host=" + this.getHost() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", bucket=" + this.getBucket() + ", bootstrapHttpDirectPort=" + this.getBootstrapHttpDirectPort() + ", httpDirectPort=" + this.getHttpDirectPort() + ", queryServicePort=" + this.getQueryServicePort() + ", queryRestTrafficPort=" + this.getQueryRestTrafficPort() + ", searchServicePort=" + this.getSearchServicePort() + ", analyticsServicePort=" + this.getAnalyticsServicePort() + ", memcachedSslPort=" + this.getMemcachedSslPort() + ", memcachedPort=" + this.getMemcachedPort() + ", bootstrapCarrierDirectPort=" + this.getBootstrapCarrierDirectPort() + ", carrierDirectPort=" + this.getCarrierDirectPort() + ", queryRestTrafficSslPort=" + this.getQueryRestTrafficSslPort() + ", queryServiceSslPort=" + this.getQueryServiceSslPort() + ", n1qlSslPort=" + this.getN1qlSslPort() + ", searchServiceHttpsPort=" + this.getSearchServiceHttpsPort() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouchbaseProperties)) {
            return false;
        }
        CouchbaseProperties other = (CouchbaseProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$services = this.getServices();
        String other$services = other.getServices();
        if (this$services == null ? other$services != null : !this$services.equals(other$services)) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        if (this.getClusterRamMb() != other.getClusterRamMb()) {
            return false;
        }
        if (this.getBucketRamMb() != other.getBucketRamMb()) {
            return false;
        }
        String this$bucketType = this.getBucketType();
        String other$bucketType = other.getBucketType();
        if (this$bucketType == null ? other$bucketType != null : !this$bucketType.equals(other$bucketType)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        if (this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket)) {
            return false;
        }
        if (this.getBootstrapHttpDirectPort() != other.getBootstrapHttpDirectPort()) {
            return false;
        }
        if (this.getHttpDirectPort() != other.getHttpDirectPort()) {
            return false;
        }
        if (this.getQueryServicePort() != other.getQueryServicePort()) {
            return false;
        }
        if (this.getQueryRestTrafficPort() != other.getQueryRestTrafficPort()) {
            return false;
        }
        if (this.getSearchServicePort() != other.getSearchServicePort()) {
            return false;
        }
        if (this.getAnalyticsServicePort() != other.getAnalyticsServicePort()) {
            return false;
        }
        if (this.getMemcachedSslPort() != other.getMemcachedSslPort()) {
            return false;
        }
        if (this.getMemcachedPort() != other.getMemcachedPort()) {
            return false;
        }
        if (this.getBootstrapCarrierDirectPort() != other.getBootstrapCarrierDirectPort()) {
            return false;
        }
        if (this.getCarrierDirectPort() != other.getCarrierDirectPort()) {
            return false;
        }
        if (this.getQueryRestTrafficSslPort() != other.getQueryRestTrafficSslPort()) {
            return false;
        }
        if (this.getQueryServiceSslPort() != other.getQueryServiceSslPort()) {
            return false;
        }
        if (this.getN1qlSslPort() != other.getN1qlSslPort()) {
            return false;
        }
        return this.getSearchServiceHttpsPort() == other.getSearchServiceHttpsPort();
    }

    protected boolean canEqual(Object other) {
        return other instanceof CouchbaseProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $services = this.getServices();
        result = result * 59 + ($services == null ? 43 : $services.hashCode());
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        result = result * 59 + this.getClusterRamMb();
        result = result * 59 + this.getBucketRamMb();
        String $bucketType = this.getBucketType();
        result = result * 59 + ($bucketType == null ? 43 : $bucketType.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        result = result * 59 + this.getBootstrapHttpDirectPort();
        result = result * 59 + this.getHttpDirectPort();
        result = result * 59 + this.getQueryServicePort();
        result = result * 59 + this.getQueryRestTrafficPort();
        result = result * 59 + this.getSearchServicePort();
        result = result * 59 + this.getAnalyticsServicePort();
        result = result * 59 + this.getMemcachedSslPort();
        result = result * 59 + this.getMemcachedPort();
        result = result * 59 + this.getBootstrapCarrierDirectPort();
        result = result * 59 + this.getCarrierDirectPort();
        result = result * 59 + this.getQueryRestTrafficSslPort();
        result = result * 59 + this.getQueryServiceSslPort();
        result = result * 59 + this.getN1qlSslPort();
        result = result * 59 + this.getSearchServiceHttpsPort();
        return result;
    }
}

