/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.couchbase.CouchbaseProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.couchbase.BucketDefinition;
import org.testcontainers.couchbase.CouchbaseContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.couchbase.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class EmbeddedCouchbaseBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCouchbaseBootstrapConfiguration.class);

    @Bean(name={"embeddedCouchbase"}, destroyMethod="stop")
    public CouchbaseContainer couchbase(ConfigurableEnvironment environment, CouchbaseProperties properties) {
        log.info("Starting couchbase server. Docker image: {}", (Object)properties.dockerImage);
        BucketDefinition bucketDefinition = new BucketDefinition(properties.getBucket()).withPrimaryIndex(true).withQuota(properties.getBucketRamMb());
        CouchbaseContainer couchbase = (CouchbaseContainer)((CouchbaseContainer)new CouchbaseContainer(properties.dockerImage).withBucket(bucketDefinition).withEnabledServices(properties.getServices()).withCredentials(properties.getUser(), properties.getPassword()).withReuse(properties.isReuseContainer())).withCreateContainerCmdModifier(cmd -> cmd.withCapAdd(new Capability[]{Capability.NET_ADMIN}));
        couchbase.start();
        this.registerCouchbaseEnvironment(couchbase, environment, properties);
        return couchbase;
    }

    private void registerCouchbaseEnvironment(CouchbaseContainer couchbase, ConfigurableEnvironment environment, CouchbaseProperties properties) {
        Integer mappedHttpPort = couchbase.getBootstrapHttpDirectPort();
        Integer mappedCarrierPort = couchbase.getBootstrapCarrierDirectPort();
        String host = couchbase.getHost();
        System.setProperty("com.couchbase.bootstrapHttpDirectPort", String.valueOf(mappedHttpPort));
        System.setProperty("com.couchbase.bootstrapCarrierDirectPort", String.valueOf(mappedCarrierPort));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.couchbase.bootstrapHttpDirectPort", mappedHttpPort);
        map.put("embedded.couchbase.bootstrapCarrierDirectPort", mappedCarrierPort);
        map.put("embedded.couchbase.host", host);
        map.put("embedded.couchbase.bucket", properties.bucket);
        map.put("embedded.couchbase.user", properties.user);
        map.put("embedded.couchbase.password", properties.password);
        log.info("Started couchbase server. Connection details {},  Admin UI: http://localhost:{}, user: {}, password: {}", new Object[]{map, mappedHttpPort, properties.getUser(), properties.getPassword()});
        MapPropertySource propertySource = new MapPropertySource("embeddedCouchbaseInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

