/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.couchbase.CouchbaseProperties;
import com.playtika.test.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.couchbase.BucketDefinition;
import org.testcontainers.couchbase.CouchbaseContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.couchbase.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={CouchbaseProperties.class})
public class EmbeddedCouchbaseBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCouchbaseBootstrapConfiguration.class);

    @Bean
    @ConditionalOnToxiProxyEnabled(module="couchbase")
    ToxiproxyContainer.ContainerProxy couchbaseContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedCouchbase") CouchbaseContainer couchbase, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)couchbase, couchbase.getBootstrapHttpDirectPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.couchbase.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.couchbase.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.couchbase.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedCouchbaseToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Couchbase ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedCouchbase"}, destroyMethod="stop")
    public CouchbaseContainer couchbase(ConfigurableEnvironment environment, CouchbaseProperties properties, Optional<Network> network) {
        BucketDefinition bucketDefinition = new BucketDefinition(properties.getBucket()).withPrimaryIndex(true).withQuota(properties.getBucketRamMb());
        CouchbaseContainer couchbase = new CouchbaseContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withBucket(bucketDefinition).withEnabledServices(properties.getServices()).withCredentials(properties.getUser(), properties.getPassword());
        network.ifPresent(arg_0 -> ((CouchbaseContainer)couchbase).withNetwork(arg_0));
        couchbase = (CouchbaseContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)couchbase, (CommonContainerProperties)properties, (Logger)log);
        this.registerCouchbaseEnvironment(couchbase, environment, properties);
        return couchbase;
    }

    private void registerCouchbaseEnvironment(CouchbaseContainer couchbase, ConfigurableEnvironment environment, CouchbaseProperties properties) {
        Integer mappedHttpPort = couchbase.getBootstrapHttpDirectPort();
        Integer mappedCarrierPort = couchbase.getBootstrapCarrierDirectPort();
        String host = couchbase.getHost();
        System.setProperty("com.couchbase.bootstrapHttpDirectPort", String.valueOf(mappedHttpPort));
        System.setProperty("com.couchbase.bootstrapCarrierDirectPort", String.valueOf(mappedCarrierPort));
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.couchbase.bootstrapHttpDirectPort", mappedHttpPort);
        map.put("embedded.couchbase.bootstrapCarrierDirectPort", mappedCarrierPort);
        map.put("embedded.couchbase.host", host);
        map.put("embedded.couchbase.bucket", properties.bucket);
        map.put("embedded.couchbase.user", properties.user);
        map.put("embedded.couchbase.password", properties.password);
        log.info("Started couchbase server. Connection details {},  Admin UI: http://localhost:{}, user: {}, password: {}", new Object[]{map, mappedHttpPort, properties.getUser(), properties.getPassword()});
        MapPropertySource propertySource = new MapPropertySource("embeddedCouchbaseInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

