/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.couchbase;

import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.AptGetPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.couchbase.CouchbaseProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnBean(value={CouchbaseProperties.class})
@ConditionalOnProperty(value={"embedded.couchbase.enabled"}, matchIfMissing=true)
public class EmbeddedCouchbaseTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.couchbase.install")
    public InstallPackageProperties couchbasePackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller couchbasePackageInstaller(InstallPackageProperties couchbasePackageProperties, @Qualifier(value="embeddedCouchbase") GenericContainer<?> couchbase) {
        return new AptGetPackageInstaller(couchbasePackageProperties, couchbase);
    }
}

