/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.couchbase;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.testcontainers.couchbase.CouchbaseService;

@ConfigurationProperties(value="embedded.couchbase")
public class CouchbaseProperties
extends CommonContainerProperties {
    public static final String BEAN_NAME_EMBEDDED_COUCHBASE = "embeddedCouchbase";
    CouchbaseService[] services = new CouchbaseService[]{CouchbaseService.INDEX, CouchbaseService.KV, CouchbaseService.QUERY, CouchbaseService.SEARCH};
    int bucketRamMb = 100;
    String bucketType = "couchbase";
    String host = "localhost";
    String user = "Administrator";
    String password = "password";
    String bucket = "test";

    public void setPassword(String password) {
        if (password.length() < 6) {
            throw new IllegalArgumentException("Couchbase requires password length >= 6 chars, password=" + password);
        }
        this.password = password;
    }

    public String getCredentials() {
        return String.format("%s:%s", this.user, this.password);
    }

    public String getDefaultDockerImage() {
        return "couchbase/server:7.2.0";
    }

    public CouchbaseService[] getServices() {
        return this.services;
    }

    public int getBucketRamMb() {
        return this.bucketRamMb;
    }

    public String getBucketType() {
        return this.bucketType;
    }

    public String getHost() {
        return this.host;
    }

    public String getUser() {
        return this.user;
    }

    public String getPassword() {
        return this.password;
    }

    public String getBucket() {
        return this.bucket;
    }

    public void setServices(CouchbaseService[] services) {
        this.services = services;
    }

    public void setBucketRamMb(int bucketRamMb) {
        this.bucketRamMb = bucketRamMb;
    }

    public void setBucketType(String bucketType) {
        this.bucketType = bucketType;
    }

    public void setHost(String host) {
        this.host = host;
    }

    public void setUser(String user) {
        this.user = user;
    }

    public void setBucket(String bucket) {
        this.bucket = bucket;
    }

    public String toString() {
        return "CouchbaseProperties(services=" + Arrays.deepToString(this.getServices()) + ", bucketRamMb=" + this.getBucketRamMb() + ", bucketType=" + this.getBucketType() + ", host=" + this.getHost() + ", user=" + this.getUser() + ", password=" + this.getPassword() + ", bucket=" + this.getBucket() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof CouchbaseProperties)) {
            return false;
        }
        CouchbaseProperties other = (CouchbaseProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getBucketRamMb() != other.getBucketRamMb()) {
            return false;
        }
        if (!Arrays.deepEquals(this.getServices(), other.getServices())) {
            return false;
        }
        String this$bucketType = this.getBucketType();
        String other$bucketType = other.getBucketType();
        if (this$bucketType == null ? other$bucketType != null : !this$bucketType.equals(other$bucketType)) {
            return false;
        }
        String this$host = this.getHost();
        String other$host = other.getHost();
        if (this$host == null ? other$host != null : !this$host.equals(other$host)) {
            return false;
        }
        String this$user = this.getUser();
        String other$user = other.getUser();
        if (this$user == null ? other$user != null : !this$user.equals(other$user)) {
            return false;
        }
        String this$password = this.getPassword();
        String other$password = other.getPassword();
        if (this$password == null ? other$password != null : !this$password.equals(other$password)) {
            return false;
        }
        String this$bucket = this.getBucket();
        String other$bucket = other.getBucket();
        return !(this$bucket == null ? other$bucket != null : !this$bucket.equals(other$bucket));
    }

    protected boolean canEqual(Object other) {
        return other instanceof CouchbaseProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getBucketRamMb();
        result = result * 59 + Arrays.deepHashCode(this.getServices());
        String $bucketType = this.getBucketType();
        result = result * 59 + ($bucketType == null ? 43 : $bucketType.hashCode());
        String $host = this.getHost();
        result = result * 59 + ($host == null ? 43 : $host.hashCode());
        String $user = this.getUser();
        result = result * 59 + ($user == null ? 43 : $user.hashCode());
        String $password = this.getPassword();
        result = result * 59 + ($password == null ? 43 : $password.hashCode());
        String $bucket = this.getBucket();
        result = result * 59 + ($bucket == null ? 43 : $bucket.hashCode());
        return result;
    }
}

