/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.couchbase;

import com.couchbase.client.java.AsyncBucket;
import com.couchbase.client.java.Bucket;
import com.couchbase.client.java.Cluster;
import com.playtika.testcontainer.common.spring.DependsOnPostProcessor;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.config.BeanFactoryPostProcessor;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.AutoConfigureOrder;
import org.springframework.boot.autoconfigure.condition.ConditionalOnClass;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;

@AutoConfiguration(afterName={"org.springframework.boot.autoconfigure.data.couchbase.CouchbaseDataAutoConfiguration"})
@AutoConfigureOrder
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(name={"embedded.couchbase.enabled"}, matchIfMissing=true)
public class EmbeddedCouchbaseDependenciesAutoConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedCouchbaseDependenciesAutoConfiguration.class);

    @Configuration
    @ConditionalOnClass(value={Cluster.class})
    public static class CouchbaseClusterDependencyContext {
        @Bean
        public static BeanFactoryPostProcessor couchbaseClusterDependencyPostProcessor() {
            return new DependsOnPostProcessor(Cluster.class, new String[]{"embeddedCouchbase"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={AsyncBucket.class})
    public static class CouchbaseAsyncBucketDependencyContext {
        @Bean
        public static BeanFactoryPostProcessor asyncBucketDependencyPostProcessor() {
            return new DependsOnPostProcessor(AsyncBucket.class, new String[]{"embeddedCouchbase"});
        }
    }

    @Configuration
    @ConditionalOnClass(value={Bucket.class})
    public static class CouchbaseBucketDependencyContext {
        @Bean
        public static BeanFactoryPostProcessor bucketDependencyPostProcessor() {
            return new DependsOnPostProcessor(Bucket.class, new String[]{"embeddedCouchbase"});
        }
    }
}

