/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.dynamodb;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.dynamodb.DynamoDBProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.dynamodb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={DynamoDBProperties.class})
public class EmbeddedDynamoDBBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedDynamoDBBootstrapConfiguration.class);

    @Bean(name={"embeddedDynamoDb"}, destroyMethod="stop")
    public GenericContainer<?> dynamoDb(ConfigurableEnvironment environment, DynamoDBProperties properties) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.port}).waitingFor((WaitStrategy)new HostPortWaitStrategy());
        container = ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerDynamodbEnvironment(container, environment, properties);
        return container;
    }

    private void registerDynamodbEnvironment(GenericContainer<?> container, ConfigurableEnvironment environment, DynamoDBProperties properties) {
        Integer mappedPort = container.getMappedPort(properties.port);
        String host = container.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.dynamodb.port", mappedPort);
        map.put("embedded.dynamodb.host", host);
        map.put("embedded.dynamodb.accessKey", properties.getAccessKey());
        map.put("embedded.dynamodb.secretKey", properties.getSecretKey());
        log.info("Started DynamoDb server. Connection details: {}, ", map);
        log.info("Consult with the doc https://docs.aws.amazon.com/amazondynamodb/latest/developerguide/DynamoDBLocal.UsageNotes.html for more details");
        MapPropertySource propertySource = new MapPropertySource("embeddedDynamodbInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

