/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.elasticsearch;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.common.utils.YumPackageInstaller;
import java.util.Collections;
import org.elasticsearch.client.Client;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnBean(value={Client.class})
@ConditionalOnProperty(value={"embedded.elasticsearch.enabled"}, matchIfMissing=true)
public class EmbeddedElasticSearchTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.elasticsearch.install")
    public InstallPackageProperties elasticSearchPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute"));
        return properties;
    }

    @Bean
    public PackageInstaller elasticSearchPackageInstaller(InstallPackageProperties elasticSearchPackageProperties, @Qualifier(value="embeddedElasticSearch") GenericContainer elasticSearch) {
        return new YumPackageInstaller(elasticSearchPackageProperties, elasticSearch);
    }

    @Bean
    @ConditionalOnMissingBean(name={"elasticsearchNetworkTestOperations"})
    public NetworkTestOperations elasticSearchNetworkTestOperations(@Qualifier(value="embeddedElasticSearch") GenericContainer elasticSearch) {
        return new DefaultNetworkTestOperations(elasticSearch);
    }
}

