/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.elasticsearch;

import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.elasticsearch.ElasticSearchProperties;
import com.playtika.test.elasticsearch.rest.CreateIndex;
import com.playtika.test.elasticsearch.rest.WaitForGreenStatus;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.elasticsearch.ElasticsearchContainer;
import org.testcontainers.utility.DockerImageName;

class ElasticSearchContainerFactory {
    private static final DockerImageName DEFAULT_IMAGE_NAME = DockerImageName.parse((String)"docker.elastic.co/elasticsearch/elasticsearch");

    ElasticSearchContainerFactory() {
    }

    static ElasticsearchContainer create(ElasticSearchProperties properties) {
        return (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(ElasticSearchContainerFactory.getDockerImageName(properties)).withExposedPorts(new Integer[]{properties.httpPort, properties.transportPort})).withEnv("cluster.name", properties.getClusterName())).withEnv("discovery.type", "single-node")).withEnv("ES_JAVA_OPTS", ElasticSearchContainerFactory.getJavaOpts(properties))).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withCapAdd(new Capability[]{Capability.NET_ADMIN}))).waitingFor(ElasticSearchContainerFactory.getCompositeWaitStrategy(properties));
    }

    private static DockerImageName getDockerImageName(ElasticSearchProperties properties) {
        DockerImageName imageName = DockerImageName.parse((String)properties.dockerImage);
        if (imageName.getRegistry().isEmpty() && (imageName.getUnversionedPart().isEmpty() || imageName.getUnversionedPart().equals("elasticsearch"))) {
            return DEFAULT_IMAGE_NAME.withTag(imageName.getVersionPart());
        }
        if (imageName.isCompatibleWith(DEFAULT_IMAGE_NAME)) {
            return imageName;
        }
        return imageName.asCompatibleSubstituteFor(DEFAULT_IMAGE_NAME);
    }

    private static String getJavaOpts(ElasticSearchProperties properties) {
        return "-Xms" + properties.getClusterRamMb() + "m -Xmx" + properties.getClusterRamMb() + "m";
    }

    private static WaitStrategy getCompositeWaitStrategy(ElasticSearchProperties properties) {
        WaitAllStrategy strategy = new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy());
        properties.indices.forEach(index -> strategy.withStrategy((WaitStrategy)new CreateIndex(properties, (String)index)));
        return strategy.withStrategy((WaitStrategy)new WaitForGreenStatus(properties)).withStartupTimeout(ContainerUtils.DEFAULT_CONTAINER_WAIT_DURATION);
    }
}

