/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.elasticsearch;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.elasticsearch.ElasticSearchProperties;
import com.playtika.test.elasticsearch.rest.CreateIndex;
import com.playtika.test.elasticsearch.rest.WaitForGreenStatus;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

class ElasticSearchContainerFactory {
    ElasticSearchContainerFactory() {
    }

    static ElasticsearchContainer create(ElasticSearchProperties properties) {
        return (ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)((ElasticsearchContainer)new ElasticsearchContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.httpPort, properties.transportPort})).withEnv("cluster.name", properties.getClusterName())).withEnv("discovery.type", "single-node")).withEnv("ES_JAVA_OPTS", ElasticSearchContainerFactory.getJavaOpts(properties))).waitingFor(ElasticSearchContainerFactory.getCompositeWaitStrategy(properties));
    }

    private static String getJavaOpts(ElasticSearchProperties properties) {
        return "-Xms" + properties.getClusterRamMb() + "m -Xmx" + properties.getClusterRamMb() + "m";
    }

    private static WaitStrategy getCompositeWaitStrategy(ElasticSearchProperties properties) {
        WaitAllStrategy strategy = new WaitAllStrategy().withStrategy((WaitStrategy)new HostPortWaitStrategy());
        properties.indices.forEach(index -> strategy.withStrategy((WaitStrategy)new CreateIndex(properties, (String)index)));
        return strategy.withStrategy((WaitStrategy)new WaitForGreenStatus(properties)).withStartupTimeout(properties.getTimeoutDuration());
    }
}

