/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.elasticsearch;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.elasticsearch.ElasticSearchContainerFactory;
import com.playtika.test.elasticsearch.ElasticSearchProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.elasticsearch.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ElasticSearchProperties.class})
public class EmbeddedElasticSearchBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedElasticSearchBootstrapConfiguration.class);

    @ConditionalOnMissingBean(name={"embeddedElasticSearch"})
    @Bean(name={"embeddedElasticSearch"}, destroyMethod="stop")
    public ElasticsearchContainer elasticSearch(ConfigurableEnvironment environment, ElasticSearchProperties properties) {
        ElasticsearchContainer elasticSearch = ElasticSearchContainerFactory.create(properties);
        elasticSearch = (ElasticsearchContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)elasticSearch, (CommonContainerProperties)properties, (Logger)log);
        this.registerElasticSearchEnvironment(elasticSearch, environment, properties);
        return elasticSearch;
    }

    private void registerElasticSearchEnvironment(ElasticsearchContainer elasticSearch, ConfigurableEnvironment environment, ElasticSearchProperties properties) {
        Integer httpPort = elasticSearch.getMappedPort(properties.httpPort);
        Integer transportPort = elasticSearch.getMappedPort(properties.transportPort);
        String host = elasticSearch.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.elasticsearch.clusterName", properties.clusterName);
        map.put("embedded.elasticsearch.host", host);
        map.put("embedded.elasticsearch.httpPort", httpPort);
        map.put("embedded.elasticsearch.transportPort", transportPort);
        log.info("Started ElasticSearch server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedElasticSearchInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

