/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.elasticsearch;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.elasticsearch.ElasticSearchContainerFactory;
import com.playtika.testcontainer.elasticsearch.ElasticSearchProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.elasticsearch.ElasticsearchContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.elasticsearch.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={ElasticSearchProperties.class})
public class EmbeddedElasticSearchBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedElasticSearchBootstrapConfiguration.class);
    private static final String ELASTICSEARCH_NETWORK_ALIAS = "elasticsearch.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="elasticsearch")
    ToxiproxyContainer.ContainerProxy elasticsearchContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedElasticSearch") ElasticsearchContainer elasticSearch, ElasticSearchProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy((GenericContainer)elasticSearch, properties.getHttpPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.elasticsearch.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.elasticsearch.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.elasticsearch.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedElasticSearchToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started ElasticSearch ToxiProxy connection details {}", map);
        return proxy;
    }

    @ConditionalOnMissingBean(name={"embeddedElasticSearch"})
    @Bean(name={"embeddedElasticSearch"}, destroyMethod="stop")
    public ElasticsearchContainer elasticSearch(ConfigurableEnvironment environment, ElasticSearchProperties properties, Optional<Network> network) {
        ElasticsearchContainer elasticSearch = (ElasticsearchContainer)ElasticSearchContainerFactory.create(properties).withNetworkAliases(new String[]{ELASTICSEARCH_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((ElasticsearchContainer)elasticSearch).withNetwork(arg_0));
        elasticSearch = (ElasticsearchContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)elasticSearch, (CommonContainerProperties)properties, (Logger)log);
        this.registerElasticSearchEnvironment(elasticSearch, environment, properties);
        return elasticSearch;
    }

    private void registerElasticSearchEnvironment(ElasticsearchContainer elasticSearch, ConfigurableEnvironment environment, ElasticSearchProperties properties) {
        Integer httpPort = elasticSearch.getMappedPort(properties.getHttpPort());
        Integer transportPort = elasticSearch.getMappedPort(properties.getTransportPort());
        String host = elasticSearch.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.elasticsearch.clusterName", properties.getClusterName());
        map.put("embedded.elasticsearch.host", host);
        map.put("embedded.elasticsearch.httpPort", httpPort);
        map.put("embedded.elasticsearch.transportPort", transportPort);
        map.put("embedded.elasticsearch.networkAlias", ELASTICSEARCH_NETWORK_ALIAS);
        map.put("embedded.elasticsearch.internalHttpPort", properties.getHttpPort());
        map.put("embedded.elasticsearch.internalTransportPort", properties.getTransportPort());
        log.info("Started ElasticSearch server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedElasticSearchInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

