/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.git;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.git.GitProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HostPortWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.shaded.org.apache.commons.lang3.StringUtils;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.git.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GitProperties.class})
public class EmbeddedGitBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedGitBootstrapConfiguration.class);
    private static final String GIT_NETWORK_ALIAS = "git.testcontainer.docker";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="git")
    ToxiproxyContainer.ContainerProxy gitContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedGit") GenericContainer<?> embeddedGit, ConfigurableEnvironment environment, GitProperties gitProperties) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(embeddedGit, gitProperties.getPort().intValue());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.git.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.git.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.git.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedGitToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Git ToxiProxy connection details {}", map);
        return proxy;
    }

    @ConditionalOnMissingBean(name={"embeddedGit"})
    @Bean(name={"embeddedGit"}, destroyMethod="stop")
    public GenericContainer<?> embeddedGit(ConfigurableEnvironment environment, GitProperties properties, Optional<Network> network) {
        GenericContainer gitContainer = ContainerUtils.configureCommonsAndStart(this.createContainer(properties), (CommonContainerProperties)properties, (Logger)log).withNetworkAliases(new String[]{GIT_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)gitContainer).withNetwork(arg_0));
        this.registerGitEnvironment(gitContainer, environment, properties);
        return gitContainer;
    }

    private GenericContainer<?> createContainer(GitProperties properties) {
        if (StringUtils.isEmpty((CharSequence)properties.getPathToRepositories())) {
            throw new RuntimeException("embedded.git.path-to-repositories is required");
        }
        GenericContainer container = ((GenericContainer)new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withCopyFileToContainer(MountableFile.forClasspathResource((String)properties.getPathToSshdConfig()), "/etc/ssh/sshd_config").withFileSystemBind(properties.getPathToRepositories(), "/projects")).withEnv("GIT_REPOSITORIES_PATH", "/projects").withEnv("GIT_PASSWORD", properties.getPassword()).withExposedPorts(new Integer[]{properties.getPort()}).waitingFor((WaitStrategy)new HostPortWaitStrategy());
        if (StringUtils.isNotEmpty((CharSequence)properties.getPathToAuthorizedKeys())) {
            container.withFileSystemBind(properties.getPathToAuthorizedKeys(), "/home/git/.ssh/authorized_keys");
        }
        return container;
    }

    private void registerGitEnvironment(GenericContainer<?> gitContainer, ConfigurableEnvironment environment, GitProperties properties) {
        Integer mappedPort = gitContainer.getMappedPort(properties.getPort().intValue());
        String host = gitContainer.getHost();
        String password = properties.getPassword();
        String connectionString = "ssh://git@" + host + ":" + mappedPort + "/projects/%YOUR_REPO_NAME%";
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.git.port", mappedPort);
        map.put("embedded.git.host", host);
        map.put("embedded.git.password", password);
        map.put("embedded.git.networkAlias", GIT_NETWORK_ALIAS);
        map.put("embedded.git.internalPort", properties.getPort());
        MapPropertySource propertySource = new MapPropertySource("embeddedGitInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Git server. You can clone repo by using the following link: {}. %YOUR_REPO_NAME% is a name of a git repository folder inside {}", (Object)connectionString, (Object)properties.getPathToRepositories());
    }
}

