/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.pubsub;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.pubsub.PubSubResourcesGenerator;
import com.playtika.test.pubsub.PubsubProperties;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.google.pubsub.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PubsubProperties.class})
public class EmbeddedPubsubBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPubsubBootstrapConfiguration.class);
    public static final String BEAN_NAME_EMBEDDED_GOOGLE_PUBSUB_RESOURCES_GENERATOR = "embeddedGooglePubsubResourcesGenerator";
    public static final String BEAN_NAME_EMBEDDED_GOOGLE_PUBSUB_MANAGED_CHANNEL = "embeddedGooglePubsubManagedChannel";

    @Bean(name={"embeddedGooglePubsub"}, destroyMethod="stop")
    public GenericContainer pubsub(ConfigurableEnvironment environment, PubsubProperties properties) {
        log.info("Starting Google Cloud Pubsub emulator. Docker image: {}", (Object)properties.getDockerImage());
        GenericContainer container = new GenericContainer(properties.getDockerImage()).withExposedPorts(new Integer[]{properties.getPort()}).withCommand(new String[]{"/bin/sh", "-c", String.format("gcloud beta emulators pubsub start --project %s --host-port=%s:%d", properties.getProjectId(), properties.getHost(), properties.getPort())}).waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx("(?s).*started.*$"));
        container = ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerPubsubEnvironment(container, environment, properties);
        return container;
    }

    private void registerPubsubEnvironment(GenericContainer container, ConfigurableEnvironment environment, PubsubProperties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.google.pubsub.port", container.getMappedPort(properties.getPort()));
        map.put("embedded.google.pubsub.host", container.getContainerIpAddress());
        map.put("embedded.google.pubsub.project-id", properties.getProjectId());
        log.info("Started Google Cloud Pubsub emulator. Connection details: {}, ", map);
        log.info("Consult with the doc https://cloud.google.com/pubsub/docs/emulator for more details");
        MapPropertySource propertySource = new MapPropertySource("embeddedGooglePubsubInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    @Bean(name={"embeddedGooglePubsubManagedChannel"})
    public ManagedChannel managedChannel(@Qualifier(value="embeddedGooglePubsub") GenericContainer pubsub, PubsubProperties properties) {
        return ManagedChannelBuilder.forAddress((String)pubsub.getContainerIpAddress(), (int)pubsub.getMappedPort(properties.getPort())).usePlaintext().build();
    }

    @Bean(name={"embeddedGooglePubsubResourcesGenerator"})
    public PubSubResourcesGenerator pubSubResourcesGenerator(@Qualifier(value="embeddedGooglePubsubManagedChannel") ManagedChannel managedChannel, PubsubProperties properties) throws IOException {
        return new PubSubResourcesGenerator(managedChannel, properties.getProjectId(), properties.getTopicsAndSubscriptions());
    }
}

