/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.pubsub;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.pubsub.PubSubResourcesGenerator;
import com.playtika.testcontainer.pubsub.PubsubProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import io.grpc.ManagedChannel;
import io.grpc.ManagedChannelBuilder;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.google.pubsub.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={PubsubProperties.class})
public class EmbeddedPubsubBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedPubsubBootstrapConfiguration.class);
    private static final String GOOGLE_PUB_SUB_NETWORK_ALIAS = "googlepubsub.testcontainer.docker";
    public static final String BEAN_NAME_EMBEDDED_GOOGLE_PUBSUB_RESOURCES_GENERATOR = "embeddedGooglePubsubResourcesGenerator";
    public static final String BEAN_NAME_EMBEDDED_GOOGLE_PUBSUB_MANAGED_CHANNEL = "embeddedGooglePubsubManagedChannel";

    @Bean
    @ConditionalOnToxiProxyEnabled(module="google.pubsub")
    ToxiproxyContainer.ContainerProxy googlePubSubContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedGooglePubsub") GenericContainer<?> pubsub, PubsubProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(pubsub, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.google.pubsub.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.google.pubsub.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.google.pubsub.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedGooglePubSubToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Google PubSub ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedGooglePubsub"}, destroyMethod="stop")
    public GenericContainer<?> pubsub(ConfigurableEnvironment environment, PubsubProperties properties, Optional<Network> network) {
        GenericContainer pubsubContainer = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withExposedPorts(new Integer[]{properties.getPort()}).withCommand(new String[]{"/bin/sh", "-c", String.format("gcloud beta emulators pubsub start --project %s --host-port=%s:%d", properties.getProjectId(), properties.getHost(), properties.getPort())}).waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx("(?s).*started.*$")).withNetworkAliases(new String[]{GOOGLE_PUB_SUB_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)pubsubContainer).withNetwork(arg_0));
        pubsubContainer = ContainerUtils.configureCommonsAndStart((GenericContainer)pubsubContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerPubsubEnvironment(pubsubContainer, environment, properties);
        return pubsubContainer;
    }

    private void registerPubsubEnvironment(GenericContainer<?> container, ConfigurableEnvironment environment, PubsubProperties properties) {
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.google.pubsub.port", container.getMappedPort(properties.getPort()));
        map.put("embedded.google.pubsub.host", container.getHost());
        map.put("embedded.google.pubsub.project-id", properties.getProjectId());
        map.put("embedded.google.pubsub.networkAlias", GOOGLE_PUB_SUB_NETWORK_ALIAS);
        map.put("embedded.google.pubsub.internalPort", properties.getPort());
        log.info("Started Google Cloud Pubsub emulator. Connection details: {}, ", map);
        log.info("Consult with the doc https://cloud.google.com/pubsub/docs/emulator for more details");
        MapPropertySource propertySource = new MapPropertySource("embeddedGooglePubsubInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    @Bean(name={"embeddedGooglePubsubManagedChannel"})
    public ManagedChannel managedChannel(@Qualifier(value="embeddedGooglePubsub") GenericContainer<?> pubsub, PubsubProperties properties) {
        return ManagedChannelBuilder.forAddress((String)pubsub.getHost(), (int)pubsub.getMappedPort(properties.getPort())).usePlaintext().build();
    }

    @Bean(name={"embeddedGooglePubsubResourcesGenerator"})
    public PubSubResourcesGenerator pubSubResourcesGenerator(@Qualifier(value="embeddedGooglePubsubManagedChannel") ManagedChannel managedChannel, PubsubProperties properties) throws IOException {
        return new PubSubResourcesGenerator(managedChannel, properties.getProjectId(), properties.getTopicsAndSubscriptions());
    }
}

