/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.pubsub;

import com.google.api.gax.core.CredentialsProvider;
import com.google.api.gax.core.NoCredentialsProvider;
import com.google.api.gax.grpc.GrpcTransportChannel;
import com.google.api.gax.rpc.AlreadyExistsException;
import com.google.api.gax.rpc.FixedTransportChannelProvider;
import com.google.api.gax.rpc.TransportChannel;
import com.google.api.gax.rpc.TransportChannelProvider;
import com.google.cloud.pubsub.v1.Publisher;
import com.google.cloud.pubsub.v1.SubscriptionAdminClient;
import com.google.cloud.pubsub.v1.SubscriptionAdminSettings;
import com.google.cloud.pubsub.v1.TopicAdminClient;
import com.google.cloud.pubsub.v1.TopicAdminSettings;
import com.google.pubsub.v1.DeadLetterPolicy;
import com.google.pubsub.v1.ProjectSubscriptionName;
import com.google.pubsub.v1.ProjectTopicName;
import com.google.pubsub.v1.Subscription;
import com.google.pubsub.v1.Topic;
import com.google.pubsub.v1.TopicName;
import com.playtika.testcontainer.pubsub.TopicAndSubscription;
import io.grpc.ManagedChannel;
import java.io.IOException;
import java.util.Collection;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.InitializingBean;

public class PubSubResourcesGenerator
implements InitializingBean {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(PubSubResourcesGenerator.class);
    private final TransportChannelProvider channelProvider;
    private final CredentialsProvider credentialsProvider;
    private final TopicAdminClient topicAdminClient;
    private final SubscriptionAdminClient subscriptionAdminClient;
    private final String projectId;
    private final Collection<TopicAndSubscription> topicAndSubscriptions;

    public PubSubResourcesGenerator(ManagedChannel channel, String projectId, Collection<TopicAndSubscription> topicAndSubscriptions) throws IOException {
        this.projectId = projectId;
        this.topicAndSubscriptions = topicAndSubscriptions;
        this.channelProvider = FixedTransportChannelProvider.create((TransportChannel)GrpcTransportChannel.create((ManagedChannel)channel));
        this.credentialsProvider = NoCredentialsProvider.create();
        this.topicAdminClient = this.topicAdminClient();
        this.subscriptionAdminClient = this.subscriptionAdminClient();
    }

    public void afterPropertiesSet() {
        log.info("Creating topics and subscriptions.");
        this.topicAndSubscriptions.forEach(this::createTopicAndSubscription);
        log.info("Creating topics and subscriptions created.");
    }

    private void createTopicAndSubscription(TopicAndSubscription ts) {
        this.createTopic(ts.getTopic());
        if (ts.getSubscription() != null) {
            this.createSubscription(ts.getTopic(), ts.getSubscription(), ts.getDeadLetter());
        }
    }

    public Subscription createSubscription(String topicName, String subscriptionName, TopicAndSubscription.DeadLetter deadLetter) {
        ProjectTopicName topic = ProjectTopicName.of((String)this.projectId, (String)topicName);
        ProjectSubscriptionName subscription = ProjectSubscriptionName.of((String)this.projectId, (String)subscriptionName);
        try {
            log.info("Creating subscription: {}", (Object)subscription);
            Subscription.Builder builder = Subscription.newBuilder().setName(subscription.toString()).setTopic(topic.toString()).setAckDeadlineSeconds(100);
            if (deadLetter != null) {
                log.info("with DeadLetterPolicy [topic: {}, maxAttempts: {}]", (Object)deadLetter.getTopic(), (Object)deadLetter.getMaxAttempts());
                ProjectTopicName dlqTopic = ProjectTopicName.of((String)this.projectId, (String)deadLetter.getTopic());
                builder.setDeadLetterPolicy(DeadLetterPolicy.newBuilder().setMaxDeliveryAttempts(deadLetter.getMaxAttempts()).setDeadLetterTopic(dlqTopic.toString()));
            }
            return this.subscriptionAdminClient.createSubscription(builder.build());
        }
        catch (AlreadyExistsException e) {
            return this.subscriptionAdminClient.getSubscription(subscription);
        }
    }

    public Topic createTopic(String topicName) {
        ProjectTopicName topic = ProjectTopicName.of((String)this.projectId, (String)topicName);
        try {
            log.info("Creating topic: {}", (Object)topic);
            return this.topicAdminClient.createTopic(topic);
        }
        catch (AlreadyExistsException e) {
            return this.topicAdminClient.getTopic(topic);
        }
    }

    public Publisher createPublisher(String topicName) throws IOException {
        return Publisher.newBuilder((TopicName)ProjectTopicName.of((String)this.projectId, (String)topicName)).setChannelProvider(this.channelProvider).setCredentialsProvider(this.credentialsProvider).build();
    }

    private TopicAdminClient topicAdminClient() throws IOException {
        return TopicAdminClient.create((TopicAdminSettings)((TopicAdminSettings.Builder)((TopicAdminSettings.Builder)TopicAdminSettings.newBuilder().setTransportChannelProvider(this.channelProvider)).setCredentialsProvider(this.credentialsProvider)).build());
    }

    private SubscriptionAdminClient subscriptionAdminClient() throws IOException {
        return SubscriptionAdminClient.create((SubscriptionAdminSettings)((SubscriptionAdminSettings.Builder)((SubscriptionAdminSettings.Builder)SubscriptionAdminSettings.newBuilder().setTransportChannelProvider(this.channelProvider)).setCredentialsProvider(this.credentialsProvider)).build());
    }

    public Subscription getSubscription(ProjectSubscriptionName projectSubscriptionName) {
        return this.subscriptionAdminClient.getSubscription(projectSubscriptionName);
    }
}

