/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.grafana;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.grafana.GrafanaProperties;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.HttpWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.grafana.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={GrafanaProperties.class})
public class EmbeddedGrafanaBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedGrafanaBootstrapConfiguration.class);
    private static final String GRAFANA_NETWORK_ALIAS = "grafana.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean(name={"grafanaWaitStrategy"})
    public WaitStrategy grafanaWaitStrategy(GrafanaProperties properties) {
        return new HttpWaitStrategy().forPath("/").forPort(properties.getPort()).forStatusCode(200);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="grafana")
    ToxiproxyContainer.ContainerProxy grafanaContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="grafana") GenericContainer<?> grafana, GrafanaProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(grafana, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.grafana.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.grafana.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.grafana.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedGrafanaToxiproxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started Grafana ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"grafana"}, destroyMethod="stop")
    public GenericContainer<?> grafana(ConfigurableEnvironment environment, GrafanaProperties properties, WaitStrategy grafanaWaitStrategy, Optional<Network> network) {
        GenericContainer container = new GenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties)).withEnv("GF_SECURITY_ADMIN_USER", properties.getUsername()).withEnv("GF_SECURITY_ADMIN_PASSWORD", properties.getPassword()).withExposedPorts(new Integer[]{properties.getPort()}).withNetwork(Network.SHARED).withNetworkAliases(new String[]{properties.getNetworkAlias(), GRAFANA_NETWORK_ALIAS}).waitingFor(grafanaWaitStrategy);
        network.ifPresent(arg_0 -> ((GenericContainer)container).withNetwork(arg_0));
        ContainerUtils.configureCommonsAndStart((GenericContainer)container, (CommonContainerProperties)properties, (Logger)log);
        this.registerEnvironment(container, environment, properties);
        return container;
    }

    private void registerEnvironment(GenericContainer<?> grafana, ConfigurableEnvironment environment, GrafanaProperties properties) {
        Integer mappedPort = grafana.getMappedPort(properties.port);
        String host = grafana.getHost();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.grafana.host", host);
        map.put("embedded.grafana.port", mappedPort);
        map.put("embedded.grafana.username", properties.getUsername());
        map.put("embedded.grafana.password", properties.getPassword());
        map.put("embedded.grafana.networkAlias", GRAFANA_NETWORK_ALIAS);
        map.put("embedded.grafana.internalPort", properties.getPort());
        log.info("Started Grafana server. Connection details: {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedGrafanaInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

