/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.influxdb;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.influxdb.InfluxDBProperties;
import com.playtika.test.influxdb.InfluxDBStatusCheck;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.annotation.Order;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@Order(value=-2147483648)
@ConditionalOnProperty(name={"embedded.influxdb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={InfluxDBProperties.class})
public class EmbeddedInfluxDBBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedInfluxDBBootstrapConfiguration.class);

    @Bean
    @ConditionalOnMissingBean
    public InfluxDBStatusCheck postgresSQLStartupCheckStrategy(InfluxDBProperties properties) {
        return new InfluxDBStatusCheck(properties);
    }

    @Bean(name={"embeddedInfluxDB"}, destroyMethod="stop")
    public GenericContainer influxdb(ConfigurableEnvironment environment, InfluxDBProperties properties, InfluxDBStatusCheck influxDBStatusCheck) {
        log.info("Starting influxDB server. Docker image: {}", (Object)properties.dockerImage);
        GenericContainer influxdb = new GenericContainer(properties.dockerImage).withEnv("INFLUXDB_ADMIN_USER", properties.getAdminUser()).withEnv("INFLUXDB_ADMIN_PASSWORD", properties.getAdminPassword()).withEnv("INFLUXDB_HTTP_AUTH_ENABLED", String.valueOf(properties.isEnableHttpAuth())).withEnv("INFLUXDB_USER", properties.getUser()).withEnv("INFLUXDB_USER_PASSWORD", properties.getPassword()).withEnv("INFLUXDB_DB", properties.getDatabase()).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log)).withExposedPorts(new Integer[]{properties.getPort()}).waitingFor((WaitStrategy)influxDBStatusCheck).withStartupTimeout(properties.getTimeoutDuration());
        influxdb.setWaitStrategy((WaitStrategy)new WaitAllStrategy().withStrategy((WaitStrategy)Wait.forHttp((String)"/ping").withBasicCredentials(properties.getUser(), properties.getPassword()).forStatusCode(204)).withStrategy((WaitStrategy)Wait.forListeningPort()));
        influxdb.start();
        this.registerInfluxEnvironment(influxdb, environment, properties);
        return influxdb;
    }

    private void registerInfluxEnvironment(GenericContainer influx, ConfigurableEnvironment environment, InfluxDBProperties properties) {
        Integer mappedPort = influx.getMappedPort(properties.getPort());
        String host = influx.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.influxdb.port", mappedPort);
        map.put("embedded.influxdb.host", host);
        map.put("embedded.influxdb.database", properties.getDatabase());
        map.put("embedded.influxdb.user", properties.getUser());
        map.put("embedded.influxdb.password", properties.getPassword());
        String influxDBURL = "http://{}:{}";
        log.info("Started InfluxDB server. Connection details: {}, HTTP connection url: " + influxDBURL, new Object[]{map, host, mappedPort});
        MapPropertySource propertySource = new MapPropertySource("embeddedInfluxDBInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

