/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.influxdb;

import com.playtika.test.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.influxdb.InfluxDBProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.InfluxDBContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitAllStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.influxdb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={InfluxDBProperties.class})
public class EmbeddedInfluxDBBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedInfluxDBBootstrapConfiguration.class);

    @Bean(name={"embeddedInfluxDB"}, destroyMethod="stop")
    public ConcreteInfluxDbContainer influxdb(ConfigurableEnvironment environment, InfluxDBProperties properties) {
        log.info("Starting influxDB server. Docker image: {}", (Object)properties.dockerImage);
        ConcreteInfluxDbContainer influxDBContainer = new ConcreteInfluxDbContainer(properties.dockerImage);
        ((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)((ConcreteInfluxDbContainer)influxDBContainer.withAdmin(properties.getAdminUser())).withAdminPassword(properties.getAdminPassword())).withAuthEnabled(properties.isEnableHttpAuth())).withUsername(properties.getUser())).withPassword(properties.getPassword())).withDatabase(properties.getDatabase())).withExposedPorts(new Integer[]{properties.getPort()})).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log))).withReuse(properties.isReuseContainer())).withStartupTimeout(properties.getTimeoutDuration());
        influxDBContainer.waitingFor((WaitStrategy)this.getInfluxWaitStrategy(properties.getUser(), properties.getPassword()));
        influxDBContainer.start();
        this.registerInfluxEnvironment(influxDBContainer, environment, properties);
        return influxDBContainer;
    }

    private void registerInfluxEnvironment(ConcreteInfluxDbContainer influx, ConfigurableEnvironment environment, InfluxDBProperties properties) {
        Integer mappedPort = influx.getMappedPort(properties.getPort());
        String host = influx.getContainerIpAddress();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.influxdb.port", mappedPort);
        map.put("embedded.influxdb.host", host);
        map.put("embedded.influxdb.database", properties.getDatabase());
        map.put("embedded.influxdb.user", properties.getUser());
        map.put("embedded.influxdb.password", properties.getPassword());
        String influxDBURL = "http://{}:{}";
        log.info("Started InfluxDB server. Connection details: {}, HTTP connection url: " + influxDBURL, new Object[]{map, host, mappedPort});
        MapPropertySource propertySource = new MapPropertySource("embeddedInfluxDBInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }

    private WaitAllStrategy getInfluxWaitStrategy(String user, String password) {
        return new WaitAllStrategy().withStrategy((WaitStrategy)Wait.forHttp((String)"/ping").withBasicCredentials(user, password).forStatusCode(204)).withStrategy((WaitStrategy)Wait.forListeningPort());
    }

    private static class ConcreteInfluxDbContainer
    extends InfluxDBContainer<ConcreteInfluxDbContainer> {
        ConcreteInfluxDbContainer(String dockerImageName) {
            this.setDockerImageName(dockerImageName);
            this.addExposedPort(INFLUXDB_PORT);
        }
    }
}

