/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.k3s;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.k3s.K3sProperties;
import java.util.LinkedHashMap;
import java.util.Optional;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.LogMessageWaitStrategy;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.k3s.K3sContainer;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.k3s.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={K3sProperties.class})
public class EmbeddedK3sBootstrapConfiguration {
    private static final Logger log = LoggerFactory.getLogger(EmbeddedK3sBootstrapConfiguration.class);
    private static final String K3S_NETWORK_ALIAS = "k3s.testcontainer.docker";

    @Bean(name={"embeddedK3s"}, destroyMethod="stop")
    public K3sContainer k3s(ConfigurableEnvironment environment, K3sProperties properties, Optional<Network> network) {
        K3sContainer k3sContainer = new K3sContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)properties));
        ((K3sContainer)((K3sContainer)((K3sContainer)k3sContainer.withCommand(new String[]{"server", "--tls-san=" + k3sContainer.getHost()})).withExposedPorts(new Integer[]{properties.getPort()})).waitingFor((WaitStrategy)new LogMessageWaitStrategy().withRegEx(".*Node controller sync successful.*"))).withNetworkAliases(new String[]{K3S_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((K3sContainer)k3sContainer).withNetwork(arg_0));
        k3sContainer = (K3sContainer)ContainerUtils.configureCommonsAndStart((GenericContainer)k3sContainer, (CommonContainerProperties)properties, (Logger)log);
        this.registerK3sEnvironment(k3sContainer, environment, properties);
        log.info("Started K3s");
        return k3sContainer;
    }

    private void registerK3sEnvironment(K3sContainer k3s, ConfigurableEnvironment environment, K3sProperties properties) {
        String kubeConfigYaml = k3s.getKubeConfigYaml();
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.k3s.kubeconfig", kubeConfigYaml);
        map.put("embedded.k3s.networkAlias", K3S_NETWORK_ALIAS);
        map.put("embedded.k3s.internalPort", properties.getPort());
        MapPropertySource propertySource = new MapPropertySource("embeddedK3sInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

