/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.checks;

import com.playtika.test.common.checks.AbstractStartupCheckStrategy;
import com.playtika.test.kafka.properties.KafkaConfigurationProperties;
import java.beans.ConstructorProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class KafkaStatusCheck
extends AbstractStartupCheckStrategy {
    private static final Logger log = LoggerFactory.getLogger(KafkaStatusCheck.class);
    private static final String MIN_BROKERS_COUNT = "1";
    private static final String TIMEOUT_IN_SEC = "30";
    private final KafkaConfigurationProperties properties;

    public String[] getHealthCheckCmd() {
        return new String[]{"cub", "kafka-ready", MIN_BROKERS_COUNT, TIMEOUT_IN_SEC, "-b", String.format("localhost:%d", this.properties.getBrokerPort())};
    }

    @ConstructorProperties(value={"properties"})
    public KafkaStatusCheck(KafkaConfigurationProperties properties) {
        this.properties = properties;
    }
}

