/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.properties;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.kafka")
public class KafkaConfigurationProperties
extends CommonContainerProperties {
    public static final String KAFKA_BEAN_NAME = "kafka";
    protected String brokerList;
    protected String containerBrokerList;
    protected int brokerPort = 0;
    protected int containerBrokerPort = 0;
    int socketTimeoutMs = 5000;
    int bufferSize = 65536;
    String dataFileSystemBind = "target/embedded-kafka-data";
    String dockerImage = "confluentinc/cp-kafka:3.3.0";
    Collection<String> topicsToCreate = Collections.emptyList();
    final transient int replicationFactor = 1;
    final transient int logFlushIntervalMs = 1;
    final transient int replicaSocketTimeoutMs = 1000;
    final transient int controllerSocketTimeoutMs = 1000;

    @PostConstruct
    private void init() {
        if (this.brokerPort == 0) {
            this.brokerPort = ContainerUtils.getAvailableMappingPort();
        }
        if (this.containerBrokerPort == 0) {
            this.containerBrokerPort = ContainerUtils.getAvailableMappingPort();
        }
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public String getContainerBrokerList() {
        return this.containerBrokerList;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public int getContainerBrokerPort() {
        return this.containerBrokerPort;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getDataFileSystemBind() {
        return this.dataFileSystemBind;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public Collection<String> getTopicsToCreate() {
        return this.topicsToCreate;
    }

    public int getReplicationFactor() {
        ((Object)((Object)this)).getClass();
        return 1;
    }

    public int getLogFlushIntervalMs() {
        ((Object)((Object)this)).getClass();
        return 1;
    }

    public int getReplicaSocketTimeoutMs() {
        ((Object)((Object)this)).getClass();
        return 1000;
    }

    public int getControllerSocketTimeoutMs() {
        ((Object)((Object)this)).getClass();
        return 1000;
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public void setContainerBrokerList(String containerBrokerList) {
        this.containerBrokerList = containerBrokerList;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public void setContainerBrokerPort(int containerBrokerPort) {
        this.containerBrokerPort = containerBrokerPort;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setDataFileSystemBind(String dataFileSystemBind) {
        this.dataFileSystemBind = dataFileSystemBind;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setTopicsToCreate(Collection<String> topicsToCreate) {
        this.topicsToCreate = topicsToCreate;
    }

    public String toString() {
        return "KafkaConfigurationProperties(brokerList=" + this.getBrokerList() + ", containerBrokerList=" + this.getContainerBrokerList() + ", brokerPort=" + this.getBrokerPort() + ", containerBrokerPort=" + this.getContainerBrokerPort() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", bufferSize=" + this.getBufferSize() + ", dataFileSystemBind=" + this.getDataFileSystemBind() + ", dockerImage=" + this.getDockerImage() + ", topicsToCreate=" + this.getTopicsToCreate() + ", replicationFactor=" + this.getReplicationFactor() + ", logFlushIntervalMs=" + this.getLogFlushIntervalMs() + ", replicaSocketTimeoutMs=" + this.getReplicaSocketTimeoutMs() + ", controllerSocketTimeoutMs=" + this.getControllerSocketTimeoutMs() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfigurationProperties)) {
            return false;
        }
        KafkaConfigurationProperties other = (KafkaConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$brokerList = this.getBrokerList();
        String other$brokerList = other.getBrokerList();
        if (this$brokerList == null ? other$brokerList != null : !this$brokerList.equals(other$brokerList)) {
            return false;
        }
        String this$containerBrokerList = this.getContainerBrokerList();
        String other$containerBrokerList = other.getContainerBrokerList();
        if (this$containerBrokerList == null ? other$containerBrokerList != null : !this$containerBrokerList.equals(other$containerBrokerList)) {
            return false;
        }
        if (this.getBrokerPort() != other.getBrokerPort()) {
            return false;
        }
        if (this.getContainerBrokerPort() != other.getContainerBrokerPort()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        String this$dataFileSystemBind = this.getDataFileSystemBind();
        String other$dataFileSystemBind = other.getDataFileSystemBind();
        if (this$dataFileSystemBind == null ? other$dataFileSystemBind != null : !this$dataFileSystemBind.equals(other$dataFileSystemBind)) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        Collection<String> this$topicsToCreate = this.getTopicsToCreate();
        Collection<String> other$topicsToCreate = other.getTopicsToCreate();
        if (this$topicsToCreate == null ? other$topicsToCreate != null : !((Object)this$topicsToCreate).equals(other$topicsToCreate)) {
            return false;
        }
        if (this.getReplicationFactor() != other.getReplicationFactor()) {
            return false;
        }
        if (this.getLogFlushIntervalMs() != other.getLogFlushIntervalMs()) {
            return false;
        }
        if (this.getReplicaSocketTimeoutMs() != other.getReplicaSocketTimeoutMs()) {
            return false;
        }
        return this.getControllerSocketTimeoutMs() == other.getControllerSocketTimeoutMs();
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $brokerList = this.getBrokerList();
        result = result * 59 + ($brokerList == null ? 43 : $brokerList.hashCode());
        String $containerBrokerList = this.getContainerBrokerList();
        result = result * 59 + ($containerBrokerList == null ? 43 : $containerBrokerList.hashCode());
        result = result * 59 + this.getBrokerPort();
        result = result * 59 + this.getContainerBrokerPort();
        result = result * 59 + this.getSocketTimeoutMs();
        result = result * 59 + this.getBufferSize();
        String $dataFileSystemBind = this.getDataFileSystemBind();
        result = result * 59 + ($dataFileSystemBind == null ? 43 : $dataFileSystemBind.hashCode());
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        Collection<String> $topicsToCreate = this.getTopicsToCreate();
        result = result * 59 + ($topicsToCreate == null ? 43 : ((Object)$topicsToCreate).hashCode());
        result = result * 59 + this.getReplicationFactor();
        result = result * 59 + this.getLogFlushIntervalMs();
        result = result * 59 + this.getReplicaSocketTimeoutMs();
        result = result * 59 + this.getControllerSocketTimeoutMs();
        return result;
    }
}

