/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka;

import com.github.dockerjava.api.DockerClient;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.kafka.properties.KafkaConfigurationProperties;
import java.beans.ConstructorProperties;
import java.util.Collection;
import javax.annotation.PostConstruct;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.testcontainers.containers.GenericContainer;

public class KafkaTopicsConfigurer {
    private static final Logger log = LoggerFactory.getLogger(KafkaTopicsConfigurer.class);
    private final GenericContainer kafka;
    private final String kafkaZookeeperConnect;
    private final KafkaConfigurationProperties properties;

    @PostConstruct
    void configure() {
        this.createTopics(this.properties.getTopicsToCreate());
    }

    public void createTopics(Collection<String> topics) {
        if (!topics.isEmpty()) {
            log.info("Creating Kafka topics: {}", topics);
            for (String topic : topics) {
                String[] createTopicCmd = this.getCreateTopicCmd(topic, this.kafkaZookeeperConnect);
                ContainerUtils.execCmd((DockerClient)this.kafka.getDockerClient(), (String)this.kafka.getContainerId(), (String[])createTopicCmd);
            }
        }
    }

    private String[] getCreateTopicCmd(String topicName, String kafkaZookeeperConnect) {
        return new String[]{"kafka-topics", "--create", "--topic", topicName, "--partitions", "1", "--replication-factor", "1", "--if-not-exists", "--zookeeper", kafkaZookeeperConnect};
    }

    @ConstructorProperties(value={"kafka", "kafkaZookeeperConnect", "properties"})
    public KafkaTopicsConfigurer(GenericContainer kafka, String kafkaZookeeperConnect, KafkaConfigurationProperties properties) {
        this.kafka = kafka;
        this.kafkaZookeeperConnect = kafkaZookeeperConnect;
        this.properties = properties;
    }

    public GenericContainer getKafka() {
        return this.kafka;
    }

    public String getKafkaZookeeperConnect() {
        return this.kafkaZookeeperConnect;
    }

    public KafkaConfigurationProperties getProperties() {
        return this.properties;
    }
}

