/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.properties;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.zookeeper")
public class ZookeeperConfigurationProperties
extends CommonContainerProperties {
    public static final String ZOOKEEPER_BEAN_NAME = "zookeeper";
    String zookeeperConnect;
    protected String containerZookeeperConnect;
    int zookeeperPort = 0;
    int sessionTimeoutMs = 5000;
    int socketTimeoutMs = 5000;
    String dataFileSystemBind = "target/embedded-zk-data";
    String txnLogsFileSystemBind = "target/embedded-zk-txn-logs";
    String dockerImage = "confluentinc/cp-zookeeper:4.1.2";

    @PostConstruct
    private void init() {
        if (this.zookeeperPort == 0) {
            this.zookeeperPort = ContainerUtils.getAvailableMappingPort();
        }
    }

    public String getZookeeperConnect() {
        return this.zookeeperConnect;
    }

    public String getContainerZookeeperConnect() {
        return this.containerZookeeperConnect;
    }

    public int getZookeeperPort() {
        return this.zookeeperPort;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public String getDataFileSystemBind() {
        return this.dataFileSystemBind;
    }

    public String getTxnLogsFileSystemBind() {
        return this.txnLogsFileSystemBind;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public void setZookeeperConnect(String zookeeperConnect) {
        this.zookeeperConnect = zookeeperConnect;
    }

    public void setContainerZookeeperConnect(String containerZookeeperConnect) {
        this.containerZookeeperConnect = containerZookeeperConnect;
    }

    public void setZookeeperPort(int zookeeperPort) {
        this.zookeeperPort = zookeeperPort;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setDataFileSystemBind(String dataFileSystemBind) {
        this.dataFileSystemBind = dataFileSystemBind;
    }

    public void setTxnLogsFileSystemBind(String txnLogsFileSystemBind) {
        this.txnLogsFileSystemBind = txnLogsFileSystemBind;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public String toString() {
        return "ZookeeperConfigurationProperties(zookeeperConnect=" + this.getZookeeperConnect() + ", containerZookeeperConnect=" + this.getContainerZookeeperConnect() + ", zookeeperPort=" + this.getZookeeperPort() + ", sessionTimeoutMs=" + this.getSessionTimeoutMs() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", dataFileSystemBind=" + this.getDataFileSystemBind() + ", txnLogsFileSystemBind=" + this.getTxnLogsFileSystemBind() + ", dockerImage=" + this.getDockerImage() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZookeeperConfigurationProperties)) {
            return false;
        }
        ZookeeperConfigurationProperties other = (ZookeeperConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$zookeeperConnect = this.getZookeeperConnect();
        String other$zookeeperConnect = other.getZookeeperConnect();
        if (this$zookeeperConnect == null ? other$zookeeperConnect != null : !this$zookeeperConnect.equals(other$zookeeperConnect)) {
            return false;
        }
        String this$containerZookeeperConnect = this.getContainerZookeeperConnect();
        String other$containerZookeeperConnect = other.getContainerZookeeperConnect();
        if (this$containerZookeeperConnect == null ? other$containerZookeeperConnect != null : !this$containerZookeeperConnect.equals(other$containerZookeeperConnect)) {
            return false;
        }
        if (this.getZookeeperPort() != other.getZookeeperPort()) {
            return false;
        }
        if (this.getSessionTimeoutMs() != other.getSessionTimeoutMs()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        String this$dataFileSystemBind = this.getDataFileSystemBind();
        String other$dataFileSystemBind = other.getDataFileSystemBind();
        if (this$dataFileSystemBind == null ? other$dataFileSystemBind != null : !this$dataFileSystemBind.equals(other$dataFileSystemBind)) {
            return false;
        }
        String this$txnLogsFileSystemBind = this.getTxnLogsFileSystemBind();
        String other$txnLogsFileSystemBind = other.getTxnLogsFileSystemBind();
        if (this$txnLogsFileSystemBind == null ? other$txnLogsFileSystemBind != null : !this$txnLogsFileSystemBind.equals(other$txnLogsFileSystemBind)) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        return !(this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZookeeperConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $zookeeperConnect = this.getZookeeperConnect();
        result = result * 59 + ($zookeeperConnect == null ? 43 : $zookeeperConnect.hashCode());
        String $containerZookeeperConnect = this.getContainerZookeeperConnect();
        result = result * 59 + ($containerZookeeperConnect == null ? 43 : $containerZookeeperConnect.hashCode());
        result = result * 59 + this.getZookeeperPort();
        result = result * 59 + this.getSessionTimeoutMs();
        result = result * 59 + this.getSocketTimeoutMs();
        String $dataFileSystemBind = this.getDataFileSystemBind();
        result = result * 59 + ($dataFileSystemBind == null ? 43 : $dataFileSystemBind.hashCode());
        String $txnLogsFileSystemBind = this.getTxnLogsFileSystemBind();
        result = result * 59 + ($txnLogsFileSystemBind == null ? 43 : $txnLogsFileSystemBind.hashCode());
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        return result;
    }
}

