/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.properties;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.zookeeper")
public class ZookeeperConfigurationProperties
extends CommonContainerProperties {
    public static final String ZOOKEEPER_BEAN_NAME = "zookeeper";
    protected String zookeeperConnect;
    protected String containerZookeeperConnect;
    protected int zookeeperPort = 0;
    protected int sessionTimeoutMs = 5000;
    protected int socketTimeoutMs = 5000;
    protected String dockerImage = "confluentinc/cp-zookeeper:5.4.1";
    protected FileSystemBind fileSystemBind = new FileSystemBind();

    @PostConstruct
    private void init() {
        if (this.zookeeperPort == 0) {
            this.zookeeperPort = ContainerUtils.getAvailableMappingPort();
        }
    }

    public String getZookeeperConnect() {
        return this.zookeeperConnect;
    }

    public String getContainerZookeeperConnect() {
        return this.containerZookeeperConnect;
    }

    public int getZookeeperPort() {
        return this.zookeeperPort;
    }

    public int getSessionTimeoutMs() {
        return this.sessionTimeoutMs;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public FileSystemBind getFileSystemBind() {
        return this.fileSystemBind;
    }

    public void setZookeeperConnect(String zookeeperConnect) {
        this.zookeeperConnect = zookeeperConnect;
    }

    public void setContainerZookeeperConnect(String containerZookeeperConnect) {
        this.containerZookeeperConnect = containerZookeeperConnect;
    }

    public void setZookeeperPort(int zookeeperPort) {
        this.zookeeperPort = zookeeperPort;
    }

    public void setSessionTimeoutMs(int sessionTimeoutMs) {
        this.sessionTimeoutMs = sessionTimeoutMs;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setFileSystemBind(FileSystemBind fileSystemBind) {
        this.fileSystemBind = fileSystemBind;
    }

    public String toString() {
        return "ZookeeperConfigurationProperties(zookeeperConnect=" + this.getZookeeperConnect() + ", containerZookeeperConnect=" + this.getContainerZookeeperConnect() + ", zookeeperPort=" + this.getZookeeperPort() + ", sessionTimeoutMs=" + this.getSessionTimeoutMs() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", dockerImage=" + this.getDockerImage() + ", fileSystemBind=" + this.getFileSystemBind() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZookeeperConfigurationProperties)) {
            return false;
        }
        ZookeeperConfigurationProperties other = (ZookeeperConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$zookeeperConnect = this.getZookeeperConnect();
        String other$zookeeperConnect = other.getZookeeperConnect();
        if (this$zookeeperConnect == null ? other$zookeeperConnect != null : !this$zookeeperConnect.equals(other$zookeeperConnect)) {
            return false;
        }
        String this$containerZookeeperConnect = this.getContainerZookeeperConnect();
        String other$containerZookeeperConnect = other.getContainerZookeeperConnect();
        if (this$containerZookeeperConnect == null ? other$containerZookeeperConnect != null : !this$containerZookeeperConnect.equals(other$containerZookeeperConnect)) {
            return false;
        }
        if (this.getZookeeperPort() != other.getZookeeperPort()) {
            return false;
        }
        if (this.getSessionTimeoutMs() != other.getSessionTimeoutMs()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        FileSystemBind this$fileSystemBind = this.getFileSystemBind();
        FileSystemBind other$fileSystemBind = other.getFileSystemBind();
        return !(this$fileSystemBind == null ? other$fileSystemBind != null : !((Object)this$fileSystemBind).equals(other$fileSystemBind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZookeeperConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $zookeeperConnect = this.getZookeeperConnect();
        result = result * 59 + ($zookeeperConnect == null ? 43 : $zookeeperConnect.hashCode());
        String $containerZookeeperConnect = this.getContainerZookeeperConnect();
        result = result * 59 + ($containerZookeeperConnect == null ? 43 : $containerZookeeperConnect.hashCode());
        result = result * 59 + this.getZookeeperPort();
        result = result * 59 + this.getSessionTimeoutMs();
        result = result * 59 + this.getSocketTimeoutMs();
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        FileSystemBind $fileSystemBind = this.getFileSystemBind();
        result = result * 59 + ($fileSystemBind == null ? 43 : ((Object)$fileSystemBind).hashCode());
        return result;
    }

    public static final class FileSystemBind {
        private boolean enabled = true;
        private String dataFolder = "target/embedded-zk-data";
        private String txnLogsFolder = "target/embedded-zk-txn-logs";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDataFolder() {
            return this.dataFolder;
        }

        public String getTxnLogsFolder() {
            return this.txnLogsFolder;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDataFolder(String dataFolder) {
            this.dataFolder = dataFolder;
        }

        public void setTxnLogsFolder(String txnLogsFolder) {
            this.txnLogsFolder = txnLogsFolder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSystemBind)) {
                return false;
            }
            FileSystemBind other = (FileSystemBind)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$dataFolder = this.getDataFolder();
            String other$dataFolder = other.getDataFolder();
            if (this$dataFolder == null ? other$dataFolder != null : !this$dataFolder.equals(other$dataFolder)) {
                return false;
            }
            String this$txnLogsFolder = this.getTxnLogsFolder();
            String other$txnLogsFolder = other.getTxnLogsFolder();
            return !(this$txnLogsFolder == null ? other$txnLogsFolder != null : !this$txnLogsFolder.equals(other$txnLogsFolder));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $dataFolder = this.getDataFolder();
            result = result * 59 + ($dataFolder == null ? 43 : $dataFolder.hashCode());
            String $txnLogsFolder = this.getTxnLogsFolder();
            result = result * 59 + ($txnLogsFolder == null ? 43 : $txnLogsFolder.hashCode());
            return result;
        }

        public String toString() {
            return "ZookeeperConfigurationProperties.FileSystemBind(enabled=" + this.isEnabled() + ", dataFolder=" + this.getDataFolder() + ", txnLogsFolder=" + this.getTxnLogsFolder() + ")";
        }
    }
}

