/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.properties;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import javax.validation.constraints.AssertTrue;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.kafka")
public class KafkaConfigurationProperties
extends CommonContainerProperties {
    public static final String KAFKA_BEAN_NAME = "kafka";
    public static final String KAFKA_USER = "alice";
    public static final String KAFKA_PASSWORD = "alice-secret";
    protected String brokerList;
    protected String containerBrokerList;
    protected int brokerPort = 0;
    protected int containerBrokerPort = 0;
    protected int saslPlaintextBrokerPort = 0;
    protected int socketTimeoutMs = 5000;
    protected int bufferSize = 65536;
    protected String dockerImage = "confluentinc/cp-kafka:5.4.1";
    protected Collection<String> topicsToCreate = Collections.emptyList();
    Collection<String> secureTopics = Collections.emptyList();
    protected final transient int replicationFactor = 1;
    protected final transient int logFlushIntervalMs = 1;
    protected final transient int replicaSocketTimeoutMs = 1000;
    protected final transient int controllerSocketTimeoutMs = 1000;
    protected FileSystemBind fileSystemBind = new FileSystemBind();

    @PostConstruct
    private void init() {
        if (this.brokerPort == 0) {
            this.brokerPort = ContainerUtils.getAvailableMappingPort();
        }
        if (this.containerBrokerPort == 0) {
            this.containerBrokerPort = ContainerUtils.getAvailableMappingPort();
        }
        if (this.saslPlaintextBrokerPort == 0) {
            this.saslPlaintextBrokerPort = ContainerUtils.getAvailableMappingPort();
        }
    }

    @AssertTrue(message="embedded.kafka.secureTopics must be listed in embedded.kafka.topicsToCreate")
    private @AssertTrue(message="embedded.kafka.secureTopics must be listed in embedded.kafka.topicsToCreate") boolean isSecureTopicsConfigurationValid() {
        return this.topicsToCreate.containsAll(this.secureTopics);
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public String getContainerBrokerList() {
        return this.containerBrokerList;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public int getContainerBrokerPort() {
        return this.containerBrokerPort;
    }

    public int getSaslPlaintextBrokerPort() {
        return this.saslPlaintextBrokerPort;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public Collection<String> getTopicsToCreate() {
        return this.topicsToCreate;
    }

    public Collection<String> getSecureTopics() {
        return this.secureTopics;
    }

    public int getReplicationFactor() {
        ((Object)((Object)this)).getClass();
        return 1;
    }

    public int getLogFlushIntervalMs() {
        ((Object)((Object)this)).getClass();
        return 1;
    }

    public int getReplicaSocketTimeoutMs() {
        ((Object)((Object)this)).getClass();
        return 1000;
    }

    public int getControllerSocketTimeoutMs() {
        ((Object)((Object)this)).getClass();
        return 1000;
    }

    public FileSystemBind getFileSystemBind() {
        return this.fileSystemBind;
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public void setContainerBrokerList(String containerBrokerList) {
        this.containerBrokerList = containerBrokerList;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public void setContainerBrokerPort(int containerBrokerPort) {
        this.containerBrokerPort = containerBrokerPort;
    }

    public void setSaslPlaintextBrokerPort(int saslPlaintextBrokerPort) {
        this.saslPlaintextBrokerPort = saslPlaintextBrokerPort;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setTopicsToCreate(Collection<String> topicsToCreate) {
        this.topicsToCreate = topicsToCreate;
    }

    public void setSecureTopics(Collection<String> secureTopics) {
        this.secureTopics = secureTopics;
    }

    public void setFileSystemBind(FileSystemBind fileSystemBind) {
        this.fileSystemBind = fileSystemBind;
    }

    public String toString() {
        return "KafkaConfigurationProperties(brokerList=" + this.getBrokerList() + ", containerBrokerList=" + this.getContainerBrokerList() + ", brokerPort=" + this.getBrokerPort() + ", containerBrokerPort=" + this.getContainerBrokerPort() + ", saslPlaintextBrokerPort=" + this.getSaslPlaintextBrokerPort() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", bufferSize=" + this.getBufferSize() + ", dockerImage=" + this.getDockerImage() + ", topicsToCreate=" + this.getTopicsToCreate() + ", secureTopics=" + this.getSecureTopics() + ", replicationFactor=" + this.getReplicationFactor() + ", logFlushIntervalMs=" + this.getLogFlushIntervalMs() + ", replicaSocketTimeoutMs=" + this.getReplicaSocketTimeoutMs() + ", controllerSocketTimeoutMs=" + this.getControllerSocketTimeoutMs() + ", fileSystemBind=" + this.getFileSystemBind() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfigurationProperties)) {
            return false;
        }
        KafkaConfigurationProperties other = (KafkaConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        String this$brokerList = this.getBrokerList();
        String other$brokerList = other.getBrokerList();
        if (this$brokerList == null ? other$brokerList != null : !this$brokerList.equals(other$brokerList)) {
            return false;
        }
        String this$containerBrokerList = this.getContainerBrokerList();
        String other$containerBrokerList = other.getContainerBrokerList();
        if (this$containerBrokerList == null ? other$containerBrokerList != null : !this$containerBrokerList.equals(other$containerBrokerList)) {
            return false;
        }
        if (this.getBrokerPort() != other.getBrokerPort()) {
            return false;
        }
        if (this.getContainerBrokerPort() != other.getContainerBrokerPort()) {
            return false;
        }
        if (this.getSaslPlaintextBrokerPort() != other.getSaslPlaintextBrokerPort()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        Collection<String> this$topicsToCreate = this.getTopicsToCreate();
        Collection<String> other$topicsToCreate = other.getTopicsToCreate();
        if (this$topicsToCreate == null ? other$topicsToCreate != null : !((Object)this$topicsToCreate).equals(other$topicsToCreate)) {
            return false;
        }
        Collection<String> this$secureTopics = this.getSecureTopics();
        Collection<String> other$secureTopics = other.getSecureTopics();
        if (this$secureTopics == null ? other$secureTopics != null : !((Object)this$secureTopics).equals(other$secureTopics)) {
            return false;
        }
        FileSystemBind this$fileSystemBind = this.getFileSystemBind();
        FileSystemBind other$fileSystemBind = other.getFileSystemBind();
        return !(this$fileSystemBind == null ? other$fileSystemBind != null : !((Object)this$fileSystemBind).equals(other$fileSystemBind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        String $brokerList = this.getBrokerList();
        result = result * 59 + ($brokerList == null ? 43 : $brokerList.hashCode());
        String $containerBrokerList = this.getContainerBrokerList();
        result = result * 59 + ($containerBrokerList == null ? 43 : $containerBrokerList.hashCode());
        result = result * 59 + this.getBrokerPort();
        result = result * 59 + this.getContainerBrokerPort();
        result = result * 59 + this.getSaslPlaintextBrokerPort();
        result = result * 59 + this.getSocketTimeoutMs();
        result = result * 59 + this.getBufferSize();
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        Collection<String> $topicsToCreate = this.getTopicsToCreate();
        result = result * 59 + ($topicsToCreate == null ? 43 : ((Object)$topicsToCreate).hashCode());
        Collection<String> $secureTopics = this.getSecureTopics();
        result = result * 59 + ($secureTopics == null ? 43 : ((Object)$secureTopics).hashCode());
        FileSystemBind $fileSystemBind = this.getFileSystemBind();
        result = result * 59 + ($fileSystemBind == null ? 43 : ((Object)$fileSystemBind).hashCode());
        return result;
    }

    public static final class FileSystemBind {
        private boolean enabled = true;
        private String dataFolder = "target/embedded-kafka-data";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDataFolder() {
            return this.dataFolder;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDataFolder(String dataFolder) {
            this.dataFolder = dataFolder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSystemBind)) {
                return false;
            }
            FileSystemBind other = (FileSystemBind)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$dataFolder = this.getDataFolder();
            String other$dataFolder = other.getDataFolder();
            return !(this$dataFolder == null ? other$dataFolder != null : !this$dataFolder.equals(other$dataFolder));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $dataFolder = this.getDataFolder();
            result = result * 59 + ($dataFolder == null ? 43 : $dataFolder.hashCode());
            return result;
        }

        public String toString() {
            return "KafkaConfigurationProperties.FileSystemBind(enabled=" + this.isEnabled() + ", dataFolder=" + this.getDataFolder() + ")";
        }
    }
}

