/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.properties;

import com.playtika.test.common.utils.ContainerUtils;
import java.util.Collection;
import java.util.Collections;
import javax.annotation.PostConstruct;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.kafka")
public class KafkaConfigurationProperties {
    public static final String KAFKA_BEAN_NAME = "kafka";
    String brokerList;
    boolean enabled = true;
    int brokerPort = 0;
    int socketTimeoutMs = 5000;
    int bufferSize = 65536;
    String dataFileSystemBind = "target/embedded-kafka-data";
    String dockerImage = "confluentinc/cp-kafka:3.3.0";
    Collection<String> topicsToCreate = Collections.emptyList();
    final transient int replicationFactor = 1;

    @PostConstruct
    private void init() {
        if (this.brokerPort == 0) {
            this.brokerPort = ContainerUtils.getAvailableMappingPort();
        }
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public boolean isEnabled() {
        return this.enabled;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getDataFileSystemBind() {
        return this.dataFileSystemBind;
    }

    public String getDockerImage() {
        return this.dockerImage;
    }

    public Collection<String> getTopicsToCreate() {
        return this.topicsToCreate;
    }

    public int getReplicationFactor() {
        return this.replicationFactor;
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public void setEnabled(boolean enabled) {
        this.enabled = enabled;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setDataFileSystemBind(String dataFileSystemBind) {
        this.dataFileSystemBind = dataFileSystemBind;
    }

    public void setDockerImage(String dockerImage) {
        this.dockerImage = dockerImage;
    }

    public void setTopicsToCreate(Collection<String> topicsToCreate) {
        this.topicsToCreate = topicsToCreate;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfigurationProperties)) {
            return false;
        }
        KafkaConfigurationProperties other = (KafkaConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        String this$brokerList = this.getBrokerList();
        String other$brokerList = other.getBrokerList();
        if (this$brokerList == null ? other$brokerList != null : !this$brokerList.equals(other$brokerList)) {
            return false;
        }
        if (this.isEnabled() != other.isEnabled()) {
            return false;
        }
        if (this.getBrokerPort() != other.getBrokerPort()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        String this$dataFileSystemBind = this.getDataFileSystemBind();
        String other$dataFileSystemBind = other.getDataFileSystemBind();
        if (this$dataFileSystemBind == null ? other$dataFileSystemBind != null : !this$dataFileSystemBind.equals(other$dataFileSystemBind)) {
            return false;
        }
        String this$dockerImage = this.getDockerImage();
        String other$dockerImage = other.getDockerImage();
        if (this$dockerImage == null ? other$dockerImage != null : !this$dockerImage.equals(other$dockerImage)) {
            return false;
        }
        Collection<String> this$topicsToCreate = this.getTopicsToCreate();
        Collection<String> other$topicsToCreate = other.getTopicsToCreate();
        return !(this$topicsToCreate == null ? other$topicsToCreate != null : !((Object)this$topicsToCreate).equals(other$topicsToCreate));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        String $brokerList = this.getBrokerList();
        result = result * 59 + ($brokerList == null ? 43 : $brokerList.hashCode());
        result = result * 59 + (this.isEnabled() ? 79 : 97);
        result = result * 59 + this.getBrokerPort();
        result = result * 59 + this.getSocketTimeoutMs();
        result = result * 59 + this.getBufferSize();
        String $dataFileSystemBind = this.getDataFileSystemBind();
        result = result * 59 + ($dataFileSystemBind == null ? 43 : $dataFileSystemBind.hashCode());
        String $dockerImage = this.getDockerImage();
        result = result * 59 + ($dockerImage == null ? 43 : $dockerImage.hashCode());
        Collection<String> $topicsToCreate = this.getTopicsToCreate();
        result = result * 59 + ($topicsToCreate == null ? 43 : ((Object)$topicsToCreate).hashCode());
        return result;
    }

    public String toString() {
        return "KafkaConfigurationProperties(brokerList=" + this.getBrokerList() + ", enabled=" + this.isEnabled() + ", brokerPort=" + this.getBrokerPort() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", bufferSize=" + this.getBufferSize() + ", dataFileSystemBind=" + this.getDataFileSystemBind() + ", dockerImage=" + this.getDockerImage() + ", topicsToCreate=" + this.getTopicsToCreate() + ", replicationFactor=" + this.getReplicationFactor() + ")";
    }
}

