/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.configuration;

import com.playtika.test.common.operations.DefaultNetworkTestOperations;
import com.playtika.test.common.operations.NetworkTestOperations;
import com.playtika.test.common.properties.InstallPackageProperties;
import com.playtika.test.common.utils.AptGetPackageInstaller;
import com.playtika.test.common.utils.PackageInstaller;
import com.playtika.test.kafka.properties.KafkaConfigurationProperties;
import java.util.Collections;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.testcontainers.containers.GenericContainer;

@Configuration
@ConditionalOnBean(value={KafkaConfigurationProperties.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.kafka.enabled", "embedded.zookeeper.enabled"}, havingValue="true", matchIfMissing=true)
public class EmbeddedKafkaTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.kafka.install")
    public InstallPackageProperties kafkaPackageProperties() {
        InstallPackageProperties properties = new InstallPackageProperties();
        properties.setPackages(Collections.singleton("iproute2"));
        return properties;
    }

    @Bean
    public PackageInstaller kafkaPackageInstaller(InstallPackageProperties kafkaPackageProperties, @Qualifier(value="kafka") GenericContainer kafka) {
        return new AptGetPackageInstaller(kafkaPackageProperties, kafka);
    }

    @Bean
    @ConditionalOnMissingBean(name={"kafkaNetworkTestOperations"})
    public NetworkTestOperations kafkaNetworkTestOperations(@Qualifier(value="kafka") GenericContainer kafka) {
        return new DefaultNetworkTestOperations(kafka);
    }
}

