/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.configuration;

import com.github.dockerjava.api.model.Capability;
import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.kafka.properties.SchemaRegistryConfigurationProperties;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnProperty(value={"embedded.kafka.schema-registry.enabled"}, havingValue="true")
@EnableConfigurationProperties(value={SchemaRegistryConfigurationProperties.class})
public class SchemaRegistryContainerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(SchemaRegistryContainerConfiguration.class);
    public static final String SCHEMA_REGISTRY_HOST_NAME = "schema-registry.testcontainer.docker";

    @Bean(name={"schema-registry"}, destroyMethod="stop")
    public GenericContainer schemaRegistry(ConfigurableEnvironment environment, SchemaRegistryConfigurationProperties properties, @Value(value="${embedded.kafka.containerBrokerList}") String kafkaContainerBrokerList, Network network) {
        log.info("Starting schema registry server. Docker image: {}", (Object)properties.getDockerImage());
        GenericContainer schemaRegistry = ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)new FixedHostPortGenericContainer(properties.getDockerImage()).withCreateContainerCmdModifier(cmd -> cmd.withHostName(SCHEMA_REGISTRY_HOST_NAME))).withCreateContainerCmdModifier(cmd -> cmd.getHostConfig().withCapAdd(new Capability[]{Capability.NET_ADMIN}))).withEnv("SCHEMA_REGISTRY_KAFKASTORE_BOOTSTRAP_SERVERS", "PLAINTEXT://" + kafkaContainerBrokerList)).withEnv("SCHEMA_REGISTRY_HOST_NAME", SCHEMA_REGISTRY_HOST_NAME)).withEnv("SCHEMA_REGISTRY_LISTENERS", "http://0.0.0.0:" + properties.getPort())).withEnv("SCHEMA_REGISTRY_AVRO_COMPATIBILITY_LEVEL", properties.getAvroCompatibilityLevel().name())).withExposedPorts(new Integer[]{properties.getPort()})).withNetwork(network)).withNetworkAliases(new String[]{SCHEMA_REGISTRY_HOST_NAME});
        if (properties.isBasicAuthenticationEnabled()) {
            schemaRegistry.withEnv("SCHEMA_REGISTRY_AUTHENTICATION_METHOD", "BASIC").withEnv("SCHEMA_REGISTRY_AUTHENTICATION_REALM", "SchemaRegistry-Props").withEnv("SCHEMA_REGISTRY_AUTHENTICATION_ROLES", "admin").withCopyFileToContainer(MountableFile.forClasspathResource((String)"schema-registry/jaas_config.file"), "/etc/schema-registry/jaas_config.file").withCopyFileToContainer(MountableFile.forClasspathResource((String)"schema-registry/password-file"), "/etc/schema-registry/password-file").withEnv("SCHEMA_REGISTRY_OPTS", "-Djava.security.auth.login.config=/etc/schema-registry/jaas_config.file");
        }
        schemaRegistry = ContainerUtils.configureCommonsAndStart((GenericContainer)schemaRegistry, (CommonContainerProperties)properties, (Logger)log);
        this.registerSchemaRegistryEnvironment(schemaRegistry, environment, properties);
        return schemaRegistry;
    }

    private void registerSchemaRegistryEnvironment(GenericContainer schemaRegistry, ConfigurableEnvironment environment, SchemaRegistryConfigurationProperties properties) {
        String host = schemaRegistry.getContainerIpAddress();
        Integer port = schemaRegistry.getMappedPort(properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.kafka.schema-registry.host", host);
        map.put("embedded.kafka.schema-registry.port", port);
        if (properties.isBasicAuthenticationEnabled()) {
            map.put("embedded.kafka.schema-registry.username", "admin");
            map.put("embedded.kafka.schema-registry.password", "letmein");
        }
        log.info("Started Schema Registry. Connection Details: {}, Connection URI: http://{}:{}", new Object[]{map, host, port});
        MapPropertySource propertySource = new MapPropertySource("embeddedSchemaRegistryInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
    }
}

