/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.configuration;

import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.kafka.checks.ZookeeperStatusCheck;
import com.playtika.test.kafka.properties.ZookeeperConfigurationProperties;
import java.nio.file.Paths;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.LinkedHashMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.testcontainers.containers.BindMode;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.wait.strategy.WaitStrategy;

@Configuration
@ConditionalOnProperty(value={"embedded.zookeeper.enabled"}, havingValue="true", matchIfMissing=true)
@EnableConfigurationProperties(value={ZookeeperConfigurationProperties.class})
public class ZookeeperContainerConfiguration {
    private static final Logger log = LoggerFactory.getLogger(ZookeeperContainerConfiguration.class);
    public static final String ZOOKEEPER_HOST_NAME = "zookeeper.testcontainer.docker";

    @Bean
    @ConditionalOnMissingBean
    public ZookeeperStatusCheck zookeeperStartupCheckStrategy(ZookeeperConfigurationProperties zookeeperProperties) {
        return new ZookeeperStatusCheck(zookeeperProperties);
    }

    @Bean(destroyMethod="close")
    @ConditionalOnMissingBean(value={Network.class})
    public Network kafkaNetwork() {
        Network network = Network.newNetwork();
        log.info("Created docker Network id={}", (Object)network.getId());
        return network;
    }

    @Bean(name={"zookeeper"}, destroyMethod="stop")
    public GenericContainer zookeeper(ZookeeperStatusCheck zookeeperStatusCheck, ZookeeperConfigurationProperties zookeeperProperties, ConfigurableEnvironment environment, Network network) {
        String currentTimestamp = LocalDateTime.now().format(DateTimeFormatter.ofPattern("HH-mm-ss-nnnnnnnnn"));
        String zkData = Paths.get(zookeeperProperties.getDataFileSystemBind(), currentTimestamp).toAbsolutePath().toString();
        log.info("Writing zookeeper data to: {}", (Object)zkData);
        String zkTransactionLogs = Paths.get(zookeeperProperties.getTxnLogsFileSystemBind(), currentTimestamp).toAbsolutePath().toString();
        log.info("Writing zookeeper transaction logs to: {}", (Object)zkTransactionLogs);
        log.info("Starting zookeeper server. Docker image: {}", (Object)zookeeperProperties.getDockerImage());
        int mappingPort = zookeeperProperties.getZookeeperPort();
        GenericContainer zookeeper = ((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)((FixedHostPortGenericContainer)new FixedHostPortGenericContainer(zookeeperProperties.getDockerImage()).withLogConsumer(ContainerUtils.containerLogsConsumer((Logger)log))).withEnv("ZOOKEEPER_CLIENT_PORT", String.valueOf(mappingPort))).withFileSystemBind(zkData, "/var/lib/zookeeper/data", BindMode.READ_WRITE)).withFileSystemBind(zkTransactionLogs, "/var/lib/zookeeper/log", BindMode.READ_WRITE)).withExposedPorts(new Integer[]{mappingPort})).withFixedExposedPort(mappingPort, mappingPort).withNetwork(network)).withNetworkAliases(new String[]{ZOOKEEPER_HOST_NAME})).waitingFor((WaitStrategy)zookeeperStatusCheck)).withStartupTimeout(zookeeperProperties.getTimeoutDuration());
        zookeeper.start();
        this.registerZookeeperEnvironment(zookeeper, environment, zookeeperProperties);
        return zookeeper;
    }

    private void registerZookeeperEnvironment(GenericContainer zookeeper, ConfigurableEnvironment environment, ZookeeperConfigurationProperties zookeeperProperties) {
        Integer port = zookeeper.getMappedPort(zookeeperProperties.getZookeeperPort());
        String host = zookeeper.getContainerIpAddress();
        String zookeeperConnect = String.format("%s:%d", host, port);
        LinkedHashMap<String, String> map = new LinkedHashMap<String, String>();
        map.put("embedded.zookeeper.zookeeperConnect", zookeeperConnect);
        String zookeeperConnectForContainers = String.format("%s:%d", ZOOKEEPER_HOST_NAME, port);
        map.put("embedded.zookeeper.containerZookeeperConnect", zookeeperConnectForContainers);
        log.info("Started zookeeper server. Connection details:  {}", map);
        MapPropertySource propertySource = new MapPropertySource("embeddedZookeeperInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.trace("embedded.zookeeper.zookeeperConnect: {}", (Object)zookeeperConnect);
    }
}

