/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.kafka.properties;

import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.zookeeper")
public class ZookeeperConfigurationProperties {
    protected int zookeeperContainerPort = 2181;
    protected String zookeeperContainerHost = "localhost";
    protected FileSystemBind fileSystemBind = new FileSystemBind();

    public String getZookeeperConnect() {
        return String.format("%s:%d", this.getZookeeperContainerHost(), this.getZookeeperContainerPort());
    }

    public int getZookeeperContainerPort() {
        return this.zookeeperContainerPort;
    }

    public String getZookeeperContainerHost() {
        return this.zookeeperContainerHost;
    }

    public FileSystemBind getFileSystemBind() {
        return this.fileSystemBind;
    }

    public void setZookeeperContainerPort(int zookeeperContainerPort) {
        this.zookeeperContainerPort = zookeeperContainerPort;
    }

    public void setZookeeperContainerHost(String zookeeperContainerHost) {
        this.zookeeperContainerHost = zookeeperContainerHost;
    }

    public void setFileSystemBind(FileSystemBind fileSystemBind) {
        this.fileSystemBind = fileSystemBind;
    }

    public String toString() {
        return "ZookeeperConfigurationProperties(zookeeperContainerPort=" + this.getZookeeperContainerPort() + ", zookeeperContainerHost=" + this.getZookeeperContainerHost() + ", fileSystemBind=" + this.getFileSystemBind() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ZookeeperConfigurationProperties)) {
            return false;
        }
        ZookeeperConfigurationProperties other = (ZookeeperConfigurationProperties)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.getZookeeperContainerPort() != other.getZookeeperContainerPort()) {
            return false;
        }
        String this$zookeeperContainerHost = this.getZookeeperContainerHost();
        String other$zookeeperContainerHost = other.getZookeeperContainerHost();
        if (this$zookeeperContainerHost == null ? other$zookeeperContainerHost != null : !this$zookeeperContainerHost.equals(other$zookeeperContainerHost)) {
            return false;
        }
        FileSystemBind this$fileSystemBind = this.getFileSystemBind();
        FileSystemBind other$fileSystemBind = other.getFileSystemBind();
        return !(this$fileSystemBind == null ? other$fileSystemBind != null : !((Object)this$fileSystemBind).equals(other$fileSystemBind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ZookeeperConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + this.getZookeeperContainerPort();
        String $zookeeperContainerHost = this.getZookeeperContainerHost();
        result = result * 59 + ($zookeeperContainerHost == null ? 43 : $zookeeperContainerHost.hashCode());
        FileSystemBind $fileSystemBind = this.getFileSystemBind();
        result = result * 59 + ($fileSystemBind == null ? 43 : ((Object)$fileSystemBind).hashCode());
        return result;
    }

    public static final class FileSystemBind {
        private boolean enabled = false;
        private String dataFolder = "target/embedded-zk-data";
        private String txnLogsFolder = "target/embedded-zk-txn-logs";

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDataFolder() {
            return this.dataFolder;
        }

        public String getTxnLogsFolder() {
            return this.txnLogsFolder;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDataFolder(String dataFolder) {
            this.dataFolder = dataFolder;
        }

        public void setTxnLogsFolder(String txnLogsFolder) {
            this.txnLogsFolder = txnLogsFolder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSystemBind)) {
                return false;
            }
            FileSystemBind other = (FileSystemBind)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$dataFolder = this.getDataFolder();
            String other$dataFolder = other.getDataFolder();
            if (this$dataFolder == null ? other$dataFolder != null : !this$dataFolder.equals(other$dataFolder)) {
                return false;
            }
            String this$txnLogsFolder = this.getTxnLogsFolder();
            String other$txnLogsFolder = other.getTxnLogsFolder();
            return !(this$txnLogsFolder == null ? other$txnLogsFolder != null : !this$txnLogsFolder.equals(other$txnLogsFolder));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $dataFolder = this.getDataFolder();
            result = result * 59 + ($dataFolder == null ? 43 : $dataFolder.hashCode());
            String $txnLogsFolder = this.getTxnLogsFolder();
            result = result * 59 + ($txnLogsFolder == null ? 43 : $txnLogsFolder.hashCode());
            return result;
        }

        public String toString() {
            return "ZookeeperConfigurationProperties.FileSystemBind(enabled=" + this.isEnabled() + ", dataFolder=" + this.getDataFolder() + ", txnLogsFolder=" + this.getTxnLogsFolder() + ")";
        }
    }
}

