/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.kafka.properties;

import com.github.dockerjava.api.model.Capability;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Objects;
import javax.validation.constraints.AssertTrue;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.kafka")
public class KafkaConfigurationProperties
extends CommonContainerProperties {
    public static final String KAFKA_BEAN_NAME = "kafka";
    public static final String KAFKA_PLAIN_TEXT_TOXI_PROXY_BEAN_NAME = "kafkaPlainTextContainerProxy";
    public static final String KAFKA_SASL_TOXI_PROXY_BEAN_NAME = "kafkaSaslContainerProxy";
    public static final String KAFKA_USER = "alice";
    public static final String KAFKA_PASSWORD = "alice-secret";
    protected String brokerList;
    protected String containerBrokerList;
    protected int internalBrokerPort = 9092;
    protected int brokerPort = 9093;
    protected int containerBrokerPort = 9094;
    protected int saslPlaintextBrokerPort = 9095;
    protected int toxiProxyContainerBrokerPort = 9096;
    protected int toxiProxySaslPlaintextContainerBrokerPort = 9097;
    protected int internalSaslPlaintextBrokerPort = 9098;
    protected int socketTimeoutMs = 5000;
    protected int bufferSize = 65536;
    protected String dockerUser = "appuser";
    protected Collection<String> topicsToCreate = Collections.emptyList();
    protected Collection<TopicConfiguration> topicsConfiguration = Collections.emptyList();
    Collection<String> secureTopics = Collections.emptyList();
    protected final transient int offsetsTopicReplicationFactor = 1;
    protected final transient int logFlushIntervalMs = 1;
    protected final transient int replicaSocketTimeoutMs = 1000;
    protected final transient int controllerSocketTimeoutMs = 1000;
    protected FileSystemBind fileSystemBind = new FileSystemBind();

    public KafkaConfigurationProperties() {
        this.setCapabilities(Arrays.asList(Capability.NET_ADMIN));
    }

    public String getDefaultDockerImage() {
        return "confluentinc/cp-kafka:7.2.1";
    }

    @AssertTrue(message="embedded.kafka.secureTopics must be listed in embedded.kafka.topicsToCreate")
    private @AssertTrue(message="embedded.kafka.secureTopics must be listed in embedded.kafka.topicsToCreate") boolean isSecureTopicsConfigurationValid() {
        return this.topicsToCreate.containsAll(this.secureTopics);
    }

    public String getBrokerList() {
        return this.brokerList;
    }

    public String getContainerBrokerList() {
        return this.containerBrokerList;
    }

    public int getInternalBrokerPort() {
        return this.internalBrokerPort;
    }

    public int getBrokerPort() {
        return this.brokerPort;
    }

    public int getContainerBrokerPort() {
        return this.containerBrokerPort;
    }

    public int getSaslPlaintextBrokerPort() {
        return this.saslPlaintextBrokerPort;
    }

    public int getToxiProxyContainerBrokerPort() {
        return this.toxiProxyContainerBrokerPort;
    }

    public int getToxiProxySaslPlaintextContainerBrokerPort() {
        return this.toxiProxySaslPlaintextContainerBrokerPort;
    }

    public int getInternalSaslPlaintextBrokerPort() {
        return this.internalSaslPlaintextBrokerPort;
    }

    public int getSocketTimeoutMs() {
        return this.socketTimeoutMs;
    }

    public int getBufferSize() {
        return this.bufferSize;
    }

    public String getDockerUser() {
        return this.dockerUser;
    }

    public Collection<String> getTopicsToCreate() {
        return this.topicsToCreate;
    }

    public Collection<TopicConfiguration> getTopicsConfiguration() {
        return this.topicsConfiguration;
    }

    public Collection<String> getSecureTopics() {
        return this.secureTopics;
    }

    public int getOffsetsTopicReplicationFactor() {
        Objects.requireNonNull(this);
        return 1;
    }

    public int getLogFlushIntervalMs() {
        Objects.requireNonNull(this);
        return 1;
    }

    public int getReplicaSocketTimeoutMs() {
        Objects.requireNonNull(this);
        return 1000;
    }

    public int getControllerSocketTimeoutMs() {
        Objects.requireNonNull(this);
        return 1000;
    }

    public FileSystemBind getFileSystemBind() {
        return this.fileSystemBind;
    }

    public void setBrokerList(String brokerList) {
        this.brokerList = brokerList;
    }

    public void setContainerBrokerList(String containerBrokerList) {
        this.containerBrokerList = containerBrokerList;
    }

    public void setInternalBrokerPort(int internalBrokerPort) {
        this.internalBrokerPort = internalBrokerPort;
    }

    public void setBrokerPort(int brokerPort) {
        this.brokerPort = brokerPort;
    }

    public void setContainerBrokerPort(int containerBrokerPort) {
        this.containerBrokerPort = containerBrokerPort;
    }

    public void setSaslPlaintextBrokerPort(int saslPlaintextBrokerPort) {
        this.saslPlaintextBrokerPort = saslPlaintextBrokerPort;
    }

    public void setToxiProxyContainerBrokerPort(int toxiProxyContainerBrokerPort) {
        this.toxiProxyContainerBrokerPort = toxiProxyContainerBrokerPort;
    }

    public void setToxiProxySaslPlaintextContainerBrokerPort(int toxiProxySaslPlaintextContainerBrokerPort) {
        this.toxiProxySaslPlaintextContainerBrokerPort = toxiProxySaslPlaintextContainerBrokerPort;
    }

    public void setInternalSaslPlaintextBrokerPort(int internalSaslPlaintextBrokerPort) {
        this.internalSaslPlaintextBrokerPort = internalSaslPlaintextBrokerPort;
    }

    public void setSocketTimeoutMs(int socketTimeoutMs) {
        this.socketTimeoutMs = socketTimeoutMs;
    }

    public void setBufferSize(int bufferSize) {
        this.bufferSize = bufferSize;
    }

    public void setDockerUser(String dockerUser) {
        this.dockerUser = dockerUser;
    }

    public void setTopicsToCreate(Collection<String> topicsToCreate) {
        this.topicsToCreate = topicsToCreate;
    }

    public void setTopicsConfiguration(Collection<TopicConfiguration> topicsConfiguration) {
        this.topicsConfiguration = topicsConfiguration;
    }

    public void setSecureTopics(Collection<String> secureTopics) {
        this.secureTopics = secureTopics;
    }

    public void setFileSystemBind(FileSystemBind fileSystemBind) {
        this.fileSystemBind = fileSystemBind;
    }

    public String toString() {
        return "KafkaConfigurationProperties(brokerList=" + this.getBrokerList() + ", containerBrokerList=" + this.getContainerBrokerList() + ", internalBrokerPort=" + this.getInternalBrokerPort() + ", brokerPort=" + this.getBrokerPort() + ", containerBrokerPort=" + this.getContainerBrokerPort() + ", saslPlaintextBrokerPort=" + this.getSaslPlaintextBrokerPort() + ", toxiProxyContainerBrokerPort=" + this.getToxiProxyContainerBrokerPort() + ", toxiProxySaslPlaintextContainerBrokerPort=" + this.getToxiProxySaslPlaintextContainerBrokerPort() + ", internalSaslPlaintextBrokerPort=" + this.getInternalSaslPlaintextBrokerPort() + ", socketTimeoutMs=" + this.getSocketTimeoutMs() + ", bufferSize=" + this.getBufferSize() + ", dockerUser=" + this.getDockerUser() + ", topicsToCreate=" + this.getTopicsToCreate() + ", topicsConfiguration=" + this.getTopicsConfiguration() + ", secureTopics=" + this.getSecureTopics() + ", offsetsTopicReplicationFactor=" + this.getOffsetsTopicReplicationFactor() + ", logFlushIntervalMs=" + this.getLogFlushIntervalMs() + ", replicaSocketTimeoutMs=" + this.getReplicaSocketTimeoutMs() + ", controllerSocketTimeoutMs=" + this.getControllerSocketTimeoutMs() + ", fileSystemBind=" + this.getFileSystemBind() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof KafkaConfigurationProperties)) {
            return false;
        }
        KafkaConfigurationProperties other = (KafkaConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getInternalBrokerPort() != other.getInternalBrokerPort()) {
            return false;
        }
        if (this.getBrokerPort() != other.getBrokerPort()) {
            return false;
        }
        if (this.getContainerBrokerPort() != other.getContainerBrokerPort()) {
            return false;
        }
        if (this.getSaslPlaintextBrokerPort() != other.getSaslPlaintextBrokerPort()) {
            return false;
        }
        if (this.getToxiProxyContainerBrokerPort() != other.getToxiProxyContainerBrokerPort()) {
            return false;
        }
        if (this.getToxiProxySaslPlaintextContainerBrokerPort() != other.getToxiProxySaslPlaintextContainerBrokerPort()) {
            return false;
        }
        if (this.getInternalSaslPlaintextBrokerPort() != other.getInternalSaslPlaintextBrokerPort()) {
            return false;
        }
        if (this.getSocketTimeoutMs() != other.getSocketTimeoutMs()) {
            return false;
        }
        if (this.getBufferSize() != other.getBufferSize()) {
            return false;
        }
        String this$brokerList = this.getBrokerList();
        String other$brokerList = other.getBrokerList();
        if (this$brokerList == null ? other$brokerList != null : !this$brokerList.equals(other$brokerList)) {
            return false;
        }
        String this$containerBrokerList = this.getContainerBrokerList();
        String other$containerBrokerList = other.getContainerBrokerList();
        if (this$containerBrokerList == null ? other$containerBrokerList != null : !this$containerBrokerList.equals(other$containerBrokerList)) {
            return false;
        }
        String this$dockerUser = this.getDockerUser();
        String other$dockerUser = other.getDockerUser();
        if (this$dockerUser == null ? other$dockerUser != null : !this$dockerUser.equals(other$dockerUser)) {
            return false;
        }
        Collection<String> this$topicsToCreate = this.getTopicsToCreate();
        Collection<String> other$topicsToCreate = other.getTopicsToCreate();
        if (this$topicsToCreate == null ? other$topicsToCreate != null : !((Object)this$topicsToCreate).equals(other$topicsToCreate)) {
            return false;
        }
        Collection<TopicConfiguration> this$topicsConfiguration = this.getTopicsConfiguration();
        Collection<TopicConfiguration> other$topicsConfiguration = other.getTopicsConfiguration();
        if (this$topicsConfiguration == null ? other$topicsConfiguration != null : !((Object)this$topicsConfiguration).equals(other$topicsConfiguration)) {
            return false;
        }
        Collection<String> this$secureTopics = this.getSecureTopics();
        Collection<String> other$secureTopics = other.getSecureTopics();
        if (this$secureTopics == null ? other$secureTopics != null : !((Object)this$secureTopics).equals(other$secureTopics)) {
            return false;
        }
        FileSystemBind this$fileSystemBind = this.getFileSystemBind();
        FileSystemBind other$fileSystemBind = other.getFileSystemBind();
        return !(this$fileSystemBind == null ? other$fileSystemBind != null : !((Object)this$fileSystemBind).equals(other$fileSystemBind));
    }

    protected boolean canEqual(Object other) {
        return other instanceof KafkaConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getInternalBrokerPort();
        result = result * 59 + this.getBrokerPort();
        result = result * 59 + this.getContainerBrokerPort();
        result = result * 59 + this.getSaslPlaintextBrokerPort();
        result = result * 59 + this.getToxiProxyContainerBrokerPort();
        result = result * 59 + this.getToxiProxySaslPlaintextContainerBrokerPort();
        result = result * 59 + this.getInternalSaslPlaintextBrokerPort();
        result = result * 59 + this.getSocketTimeoutMs();
        result = result * 59 + this.getBufferSize();
        String $brokerList = this.getBrokerList();
        result = result * 59 + ($brokerList == null ? 43 : $brokerList.hashCode());
        String $containerBrokerList = this.getContainerBrokerList();
        result = result * 59 + ($containerBrokerList == null ? 43 : $containerBrokerList.hashCode());
        String $dockerUser = this.getDockerUser();
        result = result * 59 + ($dockerUser == null ? 43 : $dockerUser.hashCode());
        Collection<String> $topicsToCreate = this.getTopicsToCreate();
        result = result * 59 + ($topicsToCreate == null ? 43 : ((Object)$topicsToCreate).hashCode());
        Collection<TopicConfiguration> $topicsConfiguration = this.getTopicsConfiguration();
        result = result * 59 + ($topicsConfiguration == null ? 43 : ((Object)$topicsConfiguration).hashCode());
        Collection<String> $secureTopics = this.getSecureTopics();
        result = result * 59 + ($secureTopics == null ? 43 : ((Object)$secureTopics).hashCode());
        FileSystemBind $fileSystemBind = this.getFileSystemBind();
        result = result * 59 + ($fileSystemBind == null ? 43 : ((Object)$fileSystemBind).hashCode());
        return result;
    }

    public static final class FileSystemBind {
        private boolean enabled = false;
        private String dataFolder = "target/embedded-kafka-data";

        public FileSystemBind(boolean enabled, String dataFolder) {
            this.enabled = enabled;
            this.dataFolder = dataFolder;
        }

        public FileSystemBind() {
        }

        public boolean isEnabled() {
            return this.enabled;
        }

        public String getDataFolder() {
            return this.dataFolder;
        }

        public void setEnabled(boolean enabled) {
            this.enabled = enabled;
        }

        public void setDataFolder(String dataFolder) {
            this.dataFolder = dataFolder;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof FileSystemBind)) {
                return false;
            }
            FileSystemBind other = (FileSystemBind)o;
            if (this.isEnabled() != other.isEnabled()) {
                return false;
            }
            String this$dataFolder = this.getDataFolder();
            String other$dataFolder = other.getDataFolder();
            return !(this$dataFolder == null ? other$dataFolder != null : !this$dataFolder.equals(other$dataFolder));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + (this.isEnabled() ? 79 : 97);
            String $dataFolder = this.getDataFolder();
            result = result * 59 + ($dataFolder == null ? 43 : $dataFolder.hashCode());
            return result;
        }

        public String toString() {
            return "KafkaConfigurationProperties.FileSystemBind(enabled=" + this.isEnabled() + ", dataFolder=" + this.getDataFolder() + ")";
        }

        public FileSystemBind withEnabled(boolean enabled) {
            return this.enabled == enabled ? this : new FileSystemBind(enabled, this.dataFolder);
        }

        public FileSystemBind withDataFolder(String dataFolder) {
            return this.dataFolder == dataFolder ? this : new FileSystemBind(this.enabled, dataFolder);
        }
    }

    public static final class TopicConfiguration {
        private String topic;
        private int partitions;

        public TopicConfiguration(String topic, int partitions) {
            this.topic = topic;
            this.partitions = partitions;
        }

        public TopicConfiguration() {
        }

        public String getTopic() {
            return this.topic;
        }

        public int getPartitions() {
            return this.partitions;
        }

        public void setTopic(String topic) {
            this.topic = topic;
        }

        public void setPartitions(int partitions) {
            this.partitions = partitions;
        }

        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof TopicConfiguration)) {
                return false;
            }
            TopicConfiguration other = (TopicConfiguration)o;
            if (this.getPartitions() != other.getPartitions()) {
                return false;
            }
            String this$topic = this.getTopic();
            String other$topic = other.getTopic();
            return !(this$topic == null ? other$topic != null : !this$topic.equals(other$topic));
        }

        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            result = result * 59 + this.getPartitions();
            String $topic = this.getTopic();
            result = result * 59 + ($topic == null ? 43 : $topic.hashCode());
            return result;
        }

        public String toString() {
            return "KafkaConfigurationProperties.TopicConfiguration(topic=" + this.getTopic() + ", partitions=" + this.getPartitions() + ")";
        }
    }
}

