/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.kafka.properties;

import com.github.dockerjava.api.model.Capability;
import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import java.util.Arrays;
import org.springframework.boot.context.properties.ConfigurationProperties;

@ConfigurationProperties(value="embedded.kafka.schema-registry")
public class SchemaRegistryConfigurationProperties
extends CommonContainerProperties {
    public static final String SCHEMA_REGISTRY_BEAN_NAME = "schema-registry";
    public static final String USERNAME = "admin";
    public static final String PASSWORD = "letmein";
    private int port = 8081;
    private AvroCompatibilityLevel avroCompatibilityLevel = AvroCompatibilityLevel.BACKWARD;
    private Authentication authentication = Authentication.NONE;

    public SchemaRegistryConfigurationProperties() {
        this.setCapabilities(Arrays.asList(Capability.NET_ADMIN));
    }

    public boolean isBasicAuthenticationEnabled() {
        return this.authentication == Authentication.BASIC;
    }

    public String getDefaultDockerImage() {
        return "confluentinc/cp-schema-registry:7.4.0";
    }

    public int getPort() {
        return this.port;
    }

    public AvroCompatibilityLevel getAvroCompatibilityLevel() {
        return this.avroCompatibilityLevel;
    }

    public Authentication getAuthentication() {
        return this.authentication;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setAvroCompatibilityLevel(AvroCompatibilityLevel avroCompatibilityLevel) {
        this.avroCompatibilityLevel = avroCompatibilityLevel;
    }

    public void setAuthentication(Authentication authentication) {
        this.authentication = authentication;
    }

    public String toString() {
        return "SchemaRegistryConfigurationProperties(port=" + this.getPort() + ", avroCompatibilityLevel=" + this.getAvroCompatibilityLevel() + ", authentication=" + this.getAuthentication() + ")";
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof SchemaRegistryConfigurationProperties)) {
            return false;
        }
        SchemaRegistryConfigurationProperties other = (SchemaRegistryConfigurationProperties)((Object)o);
        if (!other.canEqual((Object)this)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        if (this.getPort() != other.getPort()) {
            return false;
        }
        AvroCompatibilityLevel this$avroCompatibilityLevel = this.getAvroCompatibilityLevel();
        AvroCompatibilityLevel other$avroCompatibilityLevel = other.getAvroCompatibilityLevel();
        if (this$avroCompatibilityLevel == null ? other$avroCompatibilityLevel != null : !((Object)((Object)this$avroCompatibilityLevel)).equals((Object)other$avroCompatibilityLevel)) {
            return false;
        }
        Authentication this$authentication = this.getAuthentication();
        Authentication other$authentication = other.getAuthentication();
        return !(this$authentication == null ? other$authentication != null : !((Object)((Object)this$authentication)).equals((Object)other$authentication));
    }

    protected boolean canEqual(Object other) {
        return other instanceof SchemaRegistryConfigurationProperties;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = super.hashCode();
        result = result * 59 + this.getPort();
        AvroCompatibilityLevel $avroCompatibilityLevel = this.getAvroCompatibilityLevel();
        result = result * 59 + ($avroCompatibilityLevel == null ? 43 : ((Object)((Object)$avroCompatibilityLevel)).hashCode());
        Authentication $authentication = this.getAuthentication();
        result = result * 59 + ($authentication == null ? 43 : ((Object)((Object)$authentication)).hashCode());
        return result;
    }

    public static enum AvroCompatibilityLevel {
        NONE,
        BACKWARD,
        BACKWARD_TRANSITIVE,
        FORWARD,
        FORWARD_TRANSITIVE,
        FULL,
        FULL_TRANSITIVE;

    }

    public static enum Authentication {
        NONE,
        BASIC;

    }
}

