/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.kafka.configuration;

import com.playtika.testcontainer.common.properties.InstallPackageProperties;
import com.playtika.testcontainer.common.utils.PackageInstaller;
import com.playtika.testcontainer.common.utils.YumPackageInstaller;
import com.playtika.testcontainer.kafka.properties.KafkaConfigurationProperties;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfiguration;
import org.springframework.boot.autoconfigure.condition.ConditionalOnBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.ConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.testcontainers.containers.GenericContainer;

@AutoConfiguration
@ConditionalOnBean(value={KafkaConfigurationProperties.class})
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@ConditionalOnProperty(value={"embedded.kafka.enabled"}, havingValue="true", matchIfMissing=true)
public class EmbeddedKafkaTestOperationsAutoConfiguration {
    @Bean
    @ConfigurationProperties(value="embedded.kafka.install")
    public InstallPackageProperties kafkaPackageProperties() {
        return new InstallPackageProperties();
    }

    @Bean
    public PackageInstaller kafkaPackageInstaller(InstallPackageProperties kafkaPackageProperties, @Qualifier(value="kafka") GenericContainer<?> kafka) {
        return new YumPackageInstaller(kafkaPackageProperties, kafka);
    }
}

