/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.test.keycloak;

import com.playtika.test.common.properties.CommonContainerProperties;
import com.playtika.test.common.utils.ContainerUtils;
import com.playtika.test.keycloak.KeycloakProperties;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.core.io.Resource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.wait.strategy.Wait;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

public class KeycloakContainer
extends GenericContainer<KeycloakContainer> {
    private static final Logger log = LoggerFactory.getLogger(KeycloakContainer.class);
    private static final int DEFAULT_HTTP_PORT_INTERNAL = 8080;
    private final KeycloakProperties properties;
    private final ResourceLoader resourceLoader;

    public KeycloakContainer(KeycloakProperties properties, ResourceLoader resourceLoader) {
        super(ContainerUtils.getDockerImageName((CommonContainerProperties)properties));
        this.properties = properties;
        this.resourceLoader = resourceLoader;
    }

    protected void configure() {
        this.withEnv("HTTP_ENABLED", String.valueOf(true));
        this.withEnv("HTTP_PORT", String.valueOf(8080));
        this.withExposedPorts(new Integer[]{8080});
        this.withEnv("KEYCLOAK_ADMIN", this.properties.getAdminUser());
        this.withEnv("KEYCLOAK_ADMIN_PASSWORD", this.properties.getAdminPassword());
        this.withDB();
        this.withCommand(this.properties.getCommand());
        this.waitingFor(this.waitForListeningPort());
        this.withImportFile(this.properties.getImportFile());
    }

    private void withDB() {
        this.withDBVendor();
        this.withDBAddr();
        this.withDBPort();
        this.withDBDatabase();
        this.withDBSchema();
        this.withDBUser();
        this.withDBUserFile();
        this.withDBPassword();
        this.withDBPasswordFile();
    }

    private void withDBVendor() {
        String dbVendor = this.properties.getDbVendor();
        if (dbVendor != null) {
            this.withEnv("DB", dbVendor);
        }
    }

    private void withDBAddr() {
        String dbAddr = this.properties.getDbAddr();
        if (dbAddr != null) {
            this.withEnv("DB_URL_HOST", dbAddr);
        }
    }

    private void withDBPort() {
        String dbPort = this.properties.getDbPort();
        if (dbPort != null) {
            this.withEnv("DB_URL_PORT", dbPort);
        }
    }

    private void withDBDatabase() {
        String dbDatabase = this.properties.getDbDatabase();
        if (dbDatabase != null) {
            this.withEnv("DB_URL_DATABASE", dbDatabase);
        }
    }

    private void withDBSchema() {
        String dbSchema = this.properties.getDbSchema();
        if (dbSchema != null) {
            this.withEnv("DB_SCHEMA", dbSchema);
        }
    }

    private void withDBUser() {
        String dbUser = this.properties.getDbUser();
        if (dbUser != null) {
            this.withEnv("DB_USERNAME", dbUser);
        }
    }

    private void withDBUserFile() {
        String dbUserFile = this.properties.getDbUserFile();
        if (dbUserFile != null) {
            this.withEnv("DB_USER_FILE", dbUserFile);
        }
    }

    private void withDBPassword() {
        String dbPassword = this.properties.getDbPassword();
        if (dbPassword != null) {
            this.withEnv("DB_PASSWORD", dbPassword);
        }
    }

    private void withDBPasswordFile() {
        String dbPasswordFile = this.properties.getDbPasswordFile();
        if (dbPasswordFile != null) {
            this.withEnv("DB_PASSWORD_FILE", dbPasswordFile);
        }
    }

    private void withImportFile(String importFile) {
        if (importFile == null) {
            return;
        }
        this.checkExists(importFile);
        String importFileInContainer = "/opt/keycloak/data/import/" + importFile;
        this.withCopyFileToContainer(MountableFile.forClasspathResource((String)importFile), importFileInContainer);
    }

    private void checkExists(String importFile) {
        Resource resource = this.resourceLoader.getResource("classpath:" + importFile);
        if (resource.exists()) {
            log.debug("Using import file: {}", (Object)resource.getFilename());
            return;
        }
        throw new ImportFileNotFoundException(importFile);
    }

    private WaitStrategy waitForListeningPort() {
        return Wait.forListeningPort().withStartupTimeout(this.properties.getTimeoutDuration());
    }

    public String getIp() {
        return this.getContainerIpAddress();
    }

    public Integer getHttpPort() {
        return this.getMappedPort(8080);
    }

    public String getAuthServerUrl() {
        return String.format("http://%s:%d%s", this.getIp(), this.getHttpPort(), this.properties.getAuthBasePath());
    }

    public static final class ImportFileNotFoundException
    extends IllegalArgumentException {
        private static final long serialVersionUID = 6350884396691857560L;

        ImportFileNotFoundException(String importFile) {
            super(String.format("Classpath resource '%s' defined through 'embedded.keycloak.import-file' does not exist.", importFile));
        }
    }
}

