/*
 * Decompiled with CFR 0.152.
 */
package com.playtika.testcontainer.keydb;

import com.playtika.testcontainer.common.properties.CommonContainerProperties;
import com.playtika.testcontainer.common.spring.DockerPresenceBootstrapConfiguration;
import com.playtika.testcontainer.common.utils.ContainerUtils;
import com.playtika.testcontainer.common.utils.FileUtils;
import com.playtika.testcontainer.keydb.EnvUtils;
import com.playtika.testcontainer.keydb.KeyDbProperties;
import com.playtika.testcontainer.keydb.wait.DefaultKeyDbClusterWaitStrategy;
import com.playtika.testcontainer.keydb.wait.KeyDbStatusCheck;
import com.playtika.testcontainer.toxiproxy.condition.ConditionalOnToxiProxyEnabled;
import java.io.IOException;
import java.nio.file.Path;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Optional;
import lombok.Generated;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Qualifier;
import org.springframework.boot.autoconfigure.AutoConfigureAfter;
import org.springframework.boot.autoconfigure.condition.ConditionalOnExpression;
import org.springframework.boot.autoconfigure.condition.ConditionalOnMissingBean;
import org.springframework.boot.autoconfigure.condition.ConditionalOnProperty;
import org.springframework.boot.context.properties.EnableConfigurationProperties;
import org.springframework.context.annotation.Bean;
import org.springframework.context.annotation.Configuration;
import org.springframework.core.env.ConfigurableEnvironment;
import org.springframework.core.env.MapPropertySource;
import org.springframework.core.env.PropertySource;
import org.springframework.core.io.ResourceLoader;
import org.testcontainers.containers.FixedHostPortGenericContainer;
import org.testcontainers.containers.GenericContainer;
import org.testcontainers.containers.Network;
import org.testcontainers.containers.ToxiproxyContainer;
import org.testcontainers.containers.wait.strategy.WaitStrategy;
import org.testcontainers.utility.MountableFile;

@Configuration
@ConditionalOnExpression(value="${embedded.containers.enabled:true}")
@AutoConfigureAfter(value={DockerPresenceBootstrapConfiguration.class})
@ConditionalOnProperty(name={"embedded.keydb.enabled"}, matchIfMissing=true)
@EnableConfigurationProperties(value={KeyDbProperties.class})
public class EmbeddedKeyDbBootstrapConfiguration {
    @Generated
    private static final Logger log = LoggerFactory.getLogger(EmbeddedKeyDbBootstrapConfiguration.class);
    public static final String KEYDB_NETWORK_ALIAS = "keydb.testcontainer.docker";
    public static final String KEYDB_WAIT_STRATEGY_BEAN_NAME = "keydbStartupCheckStrategy";
    private final ResourceLoader resourceLoader;
    private final KeyDbProperties properties;

    @Bean(name={"keydbStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"keydbStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.keydb.clustered"}, havingValue="false", matchIfMissing=true)
    public WaitStrategy keydbStartupCheckStrategy(KeyDbProperties properties) {
        return new KeyDbStatusCheck(properties);
    }

    @Bean(name={"keydbStartupCheckStrategy"})
    @ConditionalOnMissingBean(name={"keydbStartupCheckStrategy"})
    @ConditionalOnProperty(name={"embedded.keydb.clustered"}, havingValue="true")
    public WaitStrategy keydbClusterWaitStrategy(KeyDbProperties properties) {
        return new DefaultKeyDbClusterWaitStrategy(properties);
    }

    @Bean
    @ConditionalOnToxiProxyEnabled(module="keydb")
    ToxiproxyContainer.ContainerProxy keydbContainerProxy(ToxiproxyContainer toxiproxyContainer, @Qualifier(value="embeddedKeyDb") GenericContainer<?> keydb, KeyDbProperties properties, ConfigurableEnvironment environment) {
        ToxiproxyContainer.ContainerProxy proxy = toxiproxyContainer.getProxy(keydb, properties.getPort());
        LinkedHashMap<String, Object> map = new LinkedHashMap<String, Object>();
        map.put("embedded.keydb.toxiproxy.host", proxy.getContainerIpAddress());
        map.put("embedded.keydb.toxiproxy.port", proxy.getProxyPort());
        map.put("embedded.keydb.toxiproxy.proxyName", proxy.getName());
        MapPropertySource propertySource = new MapPropertySource("embeddedKeyDbToxiProxyInfo", map);
        environment.getPropertySources().addFirst((PropertySource)propertySource);
        log.info("Started KeyDb ToxiProxy connection details {}", map);
        return proxy;
    }

    @Bean(name={"embeddedKeyDb"}, destroyMethod="stop")
    public GenericContainer<?> keydb(ConfigurableEnvironment environment, @Qualifier(value="keydbStartupCheckStrategy") WaitStrategy keydbStartupCheckStrategy, Optional<Network> network) throws Exception {
        GenericContainer keydb = new FixedHostPortGenericContainer(ContainerUtils.getDockerImageName((CommonContainerProperties)this.properties).asCanonicalNameString()).withFixedExposedPort(this.properties.getPort(), this.properties.getPort()).withExposedPorts(new Integer[]{this.properties.getPort()}).withEnv("KEYDB_USER", this.properties.getUser()).withEnv("KEYDB_PASSWORD", this.properties.getPassword()).withCopyFileToContainer(MountableFile.forHostPath((Path)this.prepareKeyDbConf()), "/data/keydb.conf").withCopyFileToContainer(MountableFile.forHostPath((Path)this.prepareNodesConf()), "/data/nodes.conf").withCommand(new String[]{"keydb-server", "/data/keydb.conf"}).waitingFor(keydbStartupCheckStrategy).withNetworkAliases(new String[]{KEYDB_NETWORK_ALIAS});
        network.ifPresent(arg_0 -> ((GenericContainer)keydb).withNetwork(arg_0));
        keydb = ContainerUtils.configureCommonsAndStart((GenericContainer)keydb, (CommonContainerProperties)this.properties, (Logger)log);
        Map<String, Object> keydbEnv = EnvUtils.registerKeyDbEnvironment(environment, keydb, this.properties, this.properties.getPort());
        log.info("Started KeyDb cluster. Connection details: {}", keydbEnv);
        return keydb;
    }

    private Path prepareKeyDbConf() throws IOException {
        return FileUtils.resolveTemplateAsPath((ResourceLoader)this.resourceLoader, (String)"keydb.conf", content -> content.replace("{{requirepass}}", this.properties.isRequirepass() ? "yes" : "no").replace("{{password}}", (CharSequence)(this.properties.isRequirepass() ? "requirepass " + this.properties.getPassword() : "")).replace("{{clustered}}", this.properties.isClustered() ? "yes" : "no").replace("{{port}}", String.valueOf(this.properties.getPort())));
    }

    private Path prepareNodesConf() throws IOException {
        return FileUtils.resolveTemplateAsPath((ResourceLoader)this.resourceLoader, (String)"nodes.conf", content -> content.replace("{{port}}", String.valueOf(this.properties.getPort())).replace("{{busPort}}", String.valueOf(this.properties.getPort() + 10000)));
    }

    @Generated
    public EmbeddedKeyDbBootstrapConfiguration(ResourceLoader resourceLoader, KeyDbProperties properties) {
        this.resourceLoader = resourceLoader;
        this.properties = properties;
    }
}

